% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_remove_nodes}
\alias{g6_remove_nodes}
\alias{g6_remove_edges}
\alias{g6_remove_combos}
\title{Remove nodes/edge/combos from a g6 graph via proxy}
\usage{
g6_remove_nodes(graph, ids)

g6_remove_edges(graph, ids)

g6_remove_combos(graph, ids)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{ids}{Character vector or list containing the IDs of the nodes/edges/combos to be removed.
If a single ID is provided, it will be converted to a list internally. You can't mix
nodes, edges and combos ids, elements have to be of the same type.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function removes one or more nodes/edges/combos from an existing g6 graph instance
using a proxy object. This allows updating the graph without completely
re-rendering it.
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

See \url{https://g6.antv.antgroup.com/en/api/data#graphremovenodedata},
\url{https://g6.antv.antgroup.com/en/api/data#graphremoveedgedata} and
\url{https://g6.antv.antgroup.com/en/api/data#graphremovecombodata} for more details.
}
\note{
When a node is removed, its connected edges are also removed.
}
\seealso{
\code{\link{g6_proxy}}
}
