% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixef.R
\name{fixef}
\alias{fixef}
\alias{fixef.galamm}
\title{Extract fixed effects from galamm objects}
\usage{
\method{fixef}{galamm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{galamm}, returned from
\code{\link{galamm}}.}

\item{...}{Optional arguments passed on to other methods. Currently not used.}
}
\value{
A named \code{numeric} vector containing the requested fixed effects.
}
\description{
Extract the fixed regression coefficients.
}
\examples{
# Poisson GLMM
count_mod <- galamm(
  formula = y ~ lbas * treat + lage + v4 + (1 | subj),
  data = epilep, family = poisson
)

# Extract fixed effects
fixef(count_mod)

}
\seealso{
\code{\link[=ranef.galamm]{ranef.galamm()}} for random effects, \code{\link[=coef.galamm]{coef.galamm()}} for
coefficients more generally, and \code{\link[=confint.galamm]{confint.galamm()}} for confidence intervals.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
