% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galaxias-package.R
\docType{package}
\name{galaxias-package}
\alias{galaxias}
\alias{galaxias-package}
\title{Build repositories to share biodiversity data}
\description{
\code{galaxias} helps users describe, package and share biodiversity
information using the 'Darwin Core' data standard, which is the format used
and accepted by the Global Biodiversity Information Facility (GBIF) and its'
partner nodes. \code{galaxias} is functionally similar to \code{devtools}, but with a focus on
building Darwin Core Archives rather than R packages.

The package is named for a genus of freshwater fish.
}
\references{
If you have any questions, comments or suggestions, please email
\href{mailto:support@ala.org.au}{support@ala.org.au}.

\strong{Prepare information for Darwin Core}
\itemize{
\item \code{\link[=use_metadata_template]{use_metadata_template()}} Add a blank metadata statement template to the working directory
\item \code{\link[=suggest_workflow]{suggest_workflow()}} Advice to standardise data using the Darwin Core Standard
}

\strong{Add information to the \code{data-publish} directory}
\itemize{
\item \code{\link[=use_data]{use_data()}} Save standardised data for use in a Darwin Core Archive
\item \code{\link[=use_metadata]{use_metadata()}} Convert a metadata file from markdown to EML (\code{eml.xml}) and save for use in a Darwin Core Archive
\item \code{\link[=use_schema]{use_schema()}} Build a schema file (\code{meta.xml}) for a given directory and save for use in a Darwin Core Archive
}

\strong{Build an archive}
\itemize{
\item \code{\link[=check_directory]{check_directory()}} Check files in your local Darwin Core directory
\item \code{\link[=build_archive]{build_archive()}} Convert a directory to a Darwin Core Archive
\item \code{\link[=check_archive]{check_archive()}} Check whether archive passes Darwin Core criteria via the GBIF API
\item \code{\link[=submit_archive]{submit_archive()}} Open a browser to submit your data to the ALA
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://galaxias.ala.org.au/R/}
  \item Report bugs at \url{https://github.com/AtlasOfLivingAustralia/galaxias/issues}
}

}
\author{
\strong{Maintainer}: Martin Westgate \email{martin.westgate@csiro.au}

Authors:
\itemize{
  \item Shandiya Balasubramaniam \email{shandiya.balasubramaniam@csiro.au}
  \item Dax Kellie \email{dax.kellie@csiro.au}
}

}
\keyword{internal}
