% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghm_tidy.R
\name{ggcorrhm_tidy}
\alias{ggcorrhm_tidy}
\title{\code{ggcorrhm()} for long format data.}
\usage{
ggcorrhm_tidy(
  x,
  rows,
  cols,
  values,
  annot_rows = NULL,
  annot_cols = NULL,
  labels = NULL,
  facet_rows = NULL,
  facet_cols = NULL,
  cor_in = TRUE,
  ...
)
}
\arguments{
\item{x}{Data containing data to plot or to correlate.}

\item{rows, cols, values}{Columns to use as rows, columns, and values in the plotted matrix (if \code{cor_in} is TRUE) or the matrix to compute correlations from (\code{cor_in} is FALSE).}

\item{annot_rows, annot_cols}{Columns containing values for row and column annotations.}

\item{labels}{Column to use for cell labels, NULL for no labels, or TRUE to use the cell values. If \code{cor_in} is FALSE, only NULL, TRUE or FALSE is supported.}

\item{facet_rows, facet_cols}{Columns to use for row/column facets.}

\item{cor_in}{Logical indicating if the values are correlation values (TRUE, default) or values to be correlated. See details for more information.}

\item{...}{Additional arguments for \code{ggcorrhm()}.}
}
\value{
A ggplot2 object with the heatmap. If \code{return_data} is \code{TRUE}, plotting data is returned as well.
}
\description{
\code{ggcorrhm()} for long format data.
}
\details{
If \code{cor_in} is TRUE (the default), \code{ggcorrhm_tidy()} behaves similarly to \code{gghm_tidy()} but with the colour
scales and arguments of \code{ggcorrhm()} instead of \code{gghm()}.

If \code{cor_in} FALSE, the data is converted to wide format and the column-column correlations are computed.
This means that if asymmetric correlation matrices are to be plotted the correlations have to be computed
in advance and plotted with \code{cor_in} as TRUE. Additionally, \code{annot_rows} and \code{annot_cols} will both use
the \code{cols} column for names, and \code{labels} can only take TRUE or FALSE.

On the other hand, if \code{cor_in} is TRUE any computation of correlations is skipped, meaning that p-values
cannot be computed and would have to be generated in advance and passed as cell labels.
}
\examples{
library(dplyr)
# Basic example with long format correlation data
# Make some correlation data in long format
cor_dat <- cor(mtcars)
hm_in <- data.frame(row = rep(colnames(cor_dat), ncol(cor_dat)),
                    col = rep(colnames(cor_dat), each = ncol(cor_dat)),
                    val = as.vector(cor_dat))

ggcorrhm_tidy(hm_in, row, col, val,
              # Indicate that the data consists of correlation coefficients
              cor_in = TRUE)

# Or let the function compute the correlations
# (this limits some other functionality, see details)
raw_dat <- data.frame(row = rep(rownames(mtcars), ncol(mtcars)),
                      col = rep(colnames(mtcars), each = nrow(mtcars)),
                      val = unlist(mtcars))
ggcorrhm_tidy(raw_dat, row, col, val, cor_in = FALSE)

}
