% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_glu}
\alias{ggml_glu}
\title{Generic GLU (Gated Linear Unit) (Graph)}
\usage{
ggml_glu(ctx, a, op, swapped = FALSE)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor (first dimension must be even)}

\item{op}{GLU operation type (GGML_GLU_OP_REGLU, GGML_GLU_OP_GEGLU, etc.)}

\item{swapped}{If TRUE, swap x and gate halves (default FALSE)}
}
\value{
Tensor with shape [n/2, ...] where n is the first dimension of input
}
\description{
Creates a graph node for GLU operation with specified gating type.
GLU splits the input tensor in half along the first dimension,
applies an activation to the first half (x), and multiplies it with the second half (gate).
}
\details{
Formula: output = activation(x) * gate
where x and gate are the two halves of the input tensor.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
# Create tensor with 10 columns (will be split into 5 + 5)
a <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 10, 4)
ggml_set_f32(a, rnorm(40))
# Apply SwiGLU
r <- ggml_glu(ctx, a, GGML_GLU_OP_SWIGLU, FALSE)
graph <- ggml_build_forward_expand(ctx, r)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(r)  # Shape: 5x4
ggml_free(ctx)
}
}
