% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggml.R, R/graph.R
\name{ggml_graph_compute}
\alias{ggml_graph_compute}
\title{Compute graph}
\usage{
ggml_graph_compute(ctx, graph)

ggml_graph_compute(ctx, graph)
}
\arguments{
\item{ctx}{GGML context}

\item{graph}{Graph object created by ggml_build_forward_expand}
}
\value{
NULL (invisible)

No return value, called for side effects
}
\description{
Executes all operations in the computation graph.

Executes the computation graph using CPU backend
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
result <- ggml_relu(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_get_f32(result)
ggml_free(ctx)
}
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
ggml_set_f32(a, 1:10)
ggml_set_f32(b, 11:20)
c <- ggml_add(ctx, a, b)
graph <- ggml_build_forward_expand(ctx, c)
ggml_graph_compute(ctx, graph)
result <- ggml_get_f32(c)
ggml_free(ctx)
}
}
