% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{ggml_graph_compute_with_ctx}
\alias{ggml_graph_compute_with_ctx}
\title{Compute Graph with Context (Alternative Method)}
\usage{
ggml_graph_compute_with_ctx(ctx, graph, n_threads = 0L)
}
\arguments{
\item{ctx}{GGML context}

\item{graph}{Graph object created by ggml_build_forward_expand}

\item{n_threads}{Number of threads to use (0 for auto-detect, default: 0)}
}
\value{
No return value, called for side effects
}
\description{
Computes the computation graph using the context-based method.
This is an alternative to ggml_graph_compute() that uses
ggml_graph_plan() and ggml_graph_compute() internally.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
ggml_set_f32(a, 1:10)
c <- ggml_relu(ctx, a)
graph <- ggml_build_forward_expand(ctx, c)
ggml_graph_compute_with_ctx(ctx, graph)
result <- ggml_get_f32(c)
ggml_free(ctx)
}
}
