% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{ggml_graph_view}
\alias{ggml_graph_view}
\title{Create a View of a Subgraph}
\usage{
ggml_graph_view(graph, i0, i1)
}
\arguments{
\item{graph}{External pointer to computation graph}

\item{i0}{Start index (0-based, inclusive)}

\item{i1}{End index (exclusive)}
}
\value{
External pointer to graph view
}
\description{
Creates a view of a portion of a computation graph, containing nodes
from index i0 to i1 (exclusive). The view shares the underlying nodes
but does not include leaf tensors or gradients.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
b <- ggml_relu(ctx, a)
graph <- ggml_build_forward_expand(ctx, b)
n_nodes <- ggml_graph_n_nodes(graph)
view <- ggml_graph_view(graph, 0, n_nodes)
ggml_free(ctx)
}
}
\seealso{
Other graph: 
\code{\link{ggml_op_can_inplace}()}
}
\concept{graph}
