% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_l2_norm_inplace}
\alias{ggml_l2_norm_inplace}
\title{L2 Normalization In-place (Graph)}
\usage{
ggml_l2_norm_inplace(ctx, a, eps = 1e-05)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor (will be modified in-place)}

\item{eps}{Epsilon for numerical stability (default 1e-5)}
}
\value{
View of input tensor with L2 norm applied
}
\description{
Creates a graph node for in-place L2 normalization.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 4)
ggml_set_f32(a, c(3, 0, 0, 4))
result <- ggml_l2_norm_inplace(ctx, a)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
