% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_top_k}
\alias{ggml_top_k}
\title{Top-K Indices (Graph)}
\usage{
ggml_top_k(ctx, a, k)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor (F32)}

\item{k}{Number of top elements to return per row}
}
\value{
Tensor containing I32 indices of top-k elements (not values)
}
\description{
Returns the indices of top K elements per row.
Useful for sampling strategies in language models (top-k sampling).
Note: the resulting indices are in no particular order within top-k.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
# Logits from model output
logits <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 100)
ggml_set_f32(logits, rnorm(100))
# Get top 5 logits for sampling
top5 <- ggml_top_k(ctx, logits, 5)
graph <- ggml_build_forward_expand(ctx, top5)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
