% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulkan.R
\name{ggml_vulkan_device_memory}
\alias{ggml_vulkan_device_memory}
\title{Get Vulkan device memory}
\usage{
ggml_vulkan_device_memory(device = 0L)
}
\arguments{
\item{device}{Device index (0-based)}
}
\value{
Named list with 'free' and 'total' memory in bytes
}
\description{
Returns free and total memory for the specified Vulkan device.
}
\examples{
\donttest{
if (ggml_vulkan_available() && ggml_vulkan_device_count() > 0) {
  mem <- ggml_vulkan_device_memory(0)
  cat("Free:", mem$free / 1e9, "GB\n")
  cat("Total:", mem$total / 1e9, "GB\n")
}
}
}
