% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mono-type.R
\name{get_mono_type}
\alias{get_mono_type}
\alias{get_mono_type.character}
\alias{get_mono_type.glyrepr_structure}
\alias{get_mono_type.glyrepr_composition}
\title{Get Monosaccharide Types}
\usage{
get_mono_type(x)

\method{get_mono_type}{character}(x)

\method{get_mono_type}{glyrepr_structure}(x)

\method{get_mono_type}{glyrepr_composition}(x)
}
\arguments{
\item{x}{Either of these objects:
\itemize{
\item A character vector of monosaccharide names;
\item A glycan composition vector ("glyrepr_composition" object);
\item A glycan structure vector ("glyrepr_structure" object).
}}
}
\value{
A character vector specifying the monosaccharide type(s).
For structures and compositions, returns the type for each element.
}
\description{
This function determines the type of monosaccharides in character vectors,
glycan compositions, or glycan structures.
Supported types: "concrete" and "generic" (see details below).
}
\section{Two types of monosaccharides}{
There are two types of monosaccharides:
\itemize{
\item concrete: e.g. "Gal", "GlcNAc", "Glc", "Fuc", etc.
\item generic: e.g. "Hex", "HexNAc", "HexA", "HexN", etc.
}

For the full list of monosaccharides, use \code{\link[=available_monosaccharides]{available_monosaccharides()}}.
}

\examples{
# Character vector
get_mono_type(c("Gal", "Hex"))

# Glycan structures
get_mono_type(n_glycan_core(mono_type = "concrete"))
get_mono_type(n_glycan_core(mono_type = "generic"))

# Glycan compositions
comp <- glycan_composition(c(Glc = 2, GalNAc = 1))
get_mono_type(comp)

}
\seealso{
\code{\link[=convert_to_generic]{convert_to_generic()}}
}
