% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkage.R
\name{possible_linkages}
\alias{possible_linkages}
\title{Generate Possible Linkages}
\usage{
possible_linkages(
  linkage,
  anomer_range = c("a", "b"),
  pos1_range = 1:2,
  pos2_range = 1:9,
  include_unknown = FALSE
)
}
\arguments{
\item{linkage}{A linkage string.}

\item{anomer_range}{A character vector of possible anomers.
Default is \code{c("a", "b")}.}

\item{pos1_range}{A numeric vector of possible first positions.
Default is \code{1:2}.}

\item{pos2_range}{A numeric vector of possible second positions.
Default is \code{1:9}.}

\item{include_unknown}{A logical value. If \code{TRUE}, "?" will be included.
Default is \code{FALSE}.}
}
\value{
A character vector of possible linkages.
}
\description{
Given an obscure linkage format (having "?", e.g. "a2-?"),
this function generates all possible linkages based on the format.
See \code{\link[=valid_linkages]{valid_linkages()}} for details.

The ranges of possible anomers, first positions, and second positions
can be specified using \code{anomer_range}, \code{pos1_range}, and \code{pos2_range}.
}
\examples{
possible_linkages("a2-?")
possible_linkages("??-2")
possible_linkages("a1-3")
possible_linkages("a?-?", pos1_range = 2, pos2_range = c(2, 3))
possible_linkages("?1-6", include_unknown = TRUE)

}
\seealso{
\code{\link[=has_linkages]{has_linkages()}}, \code{\link[=remove_linkages]{remove_linkages()}}, \code{\link[=valid_linkages]{valid_linkages()}}
}
