% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai_assistant.R
\name{goose_suggest_colors}
\alias{goose_suggest_colors}
\title{Suggest Color Palette with AI}
\usage{
goose_suggest_colors(purpose, n_colors = 5, brand = NULL, constraints = NULL)
}
\arguments{
\item{purpose}{Character, the purpose of the palette (e.g., "heatmap", "categorical", "diverging")}

\item{n_colors}{Integer, number of colors needed}

\item{brand}{Optional brand name for brand-appropriate colors}

\item{constraints}{Optional constraints (e.g., "colorblind-safe", "print-friendly")}
}
\value{
List with hex colors and rationale
}
\description{
Get AI-powered color palette suggestions for data visualization.
}
\examples{
\dontrun{
# Get heatmap colors
colors <- goose_suggest_colors("heatmap", n_colors = 9)

# Get brand colors
colors <- goose_suggest_colors("categorical", n_colors = 5, brand = "Block")

# Get accessible colors
colors <- goose_suggest_colors("bar chart", n_colors = 4, 
                               constraints = "colorblind-safe")
}
}
