% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{spatial_predicates}
\alias{spatial_predicates}
\alias{intersects}
\alias{within}
\alias{disjoint}
\alias{contains}
\alias{touches}
\alias{crosses}
\alias{overlaps}
\alias{equals}
\alias{bbox}
\alias{dwithin}
\alias{beyond}
\alias{relate}
\title{Spatial predicate constructors}
\usage{
intersects()

within()

disjoint()

contains()

touches()

crosses()

overlaps()

equals()

bbox()

dwithin(distance, units = "meters")

beyond(distance, units = "meters")

relate(pattern)
}
\arguments{
\item{distance}{Numeric distance value (single value).}

\item{units}{Distance units supported by the WFS server (e.g. \code{"meters"}, \code{"kilometers"}).}

\item{pattern}{A 9-character DE-9IM pattern string.}
}
\value{
A spatial predicate object (used internally by \code{\link[=get_wfs]{get_wfs()}}).
}
\description{
These functions create spatial predicates used by \code{\link[=get_wfs]{get_wfs()}} to filter
features based on their spatial relationship with a reference geometry.
}
\details{
Predicates describe \emph{how} geometries should be compared (e.g. intersection,
containment, distance-based relations). Users should not construct predicates
manually; instead, use the helper functions listed below.
\itemize{
\item \code{bbox()}: Select features intersecting the bounding box of the reference geometry.
\item \code{intersects()}: Select features whose geometry intersects the reference geometry.
\item \code{disjoint()}: Select features whose geometry intersects the reference geometry.
\item \code{contains()}: Select features that completely contain the reference geometry.
\item \code{within()}: Select features completely within the reference geometry.
\item \code{touches()}: Select features that touch the reference geometry at the boundary.
\item \code{crosses()}: Select features that cross the reference geometry.
\item \code{overlaps()}: Select features that partially overlap the reference geometry.
\item \code{equals()}: Select features geometrically equal to the reference geometry.
\item \code{dwithin(distance, units)}: Select features within a given distance of the reference geometry.
\item \code{beyond(distance, units)}: Select features farther than a given distance from the reference geometry.
\item \code{relate(pattern)}: Select features matching a DE-9IM spatial relationship pattern.
}
}
\examples{
intersects()
bbox()
dwithin(50, "meters")
beyond(100, "meters")
relate("T*F**F***")

}
\seealso{
\code{\link[=get_wfs]{get_wfs()}}
}
