/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5Tpublic_H
#define H5Tpublic_H
#include "H5public.h"
#include "H5Ipublic.h"
#define HOFFSET(S, M) (offsetof(S, M))
//! <!-- [H5T_class_t_snip] -->
typedef enum H5T_class_t {
    H5T_NO_CLASS  = -1,
    H5T_INTEGER   = 0,
    H5T_FLOAT     = 1,
    H5T_TIME      = 2,
    H5T_STRING    = 3,
    H5T_BITFIELD  = 4,
    H5T_OPAQUE    = 5,
    H5T_COMPOUND  = 6,
    H5T_REFERENCE = 7,
    H5T_ENUM      = 8,
    H5T_VLEN      = 9,
    H5T_ARRAY     = 10,
    H5T_NCLASSES
} H5T_class_t;
//! <!-- [H5T_class_t_snip] -->
//! <!-- [H5T_order_t_snip] -->
typedef enum H5T_order_t {
    H5T_ORDER_ERROR = -1,
    H5T_ORDER_LE    = 0,
    H5T_ORDER_BE    = 1,
    H5T_ORDER_VAX   = 2,
    H5T_ORDER_MIXED = 3,
    H5T_ORDER_NONE  = 4
} H5T_order_t;
//! <!-- [H5T_order_t_snip] -->
//! <!-- [H5T_sign_t_snip] -->
typedef enum H5T_sign_t {
    H5T_SGN_ERROR = -1,
    H5T_SGN_NONE  = 0,
    H5T_SGN_2     = 1,
    H5T_NSGN = 2
} H5T_sign_t;
//! <!-- [H5T_sign_t_snip] -->
//! <!-- [H5T_norm_t_snip] -->
typedef enum H5T_norm_t {
    H5T_NORM_ERROR   = -1,
    H5T_NORM_IMPLIED = 0,
    H5T_NORM_MSBSET  = 1,
    H5T_NORM_NONE    = 2
} H5T_norm_t;
//! <!-- [H5T_norm_t_snip] -->
typedef enum H5T_cset_t {
    H5T_CSET_ERROR       = -1,
    H5T_CSET_ASCII       = 0,
    H5T_CSET_UTF8        = 1,
    H5T_CSET_RESERVED_2  = 2,
    H5T_CSET_RESERVED_3  = 3,
    H5T_CSET_RESERVED_4  = 4,
    H5T_CSET_RESERVED_5  = 5,
    H5T_CSET_RESERVED_6  = 6,
    H5T_CSET_RESERVED_7  = 7,
    H5T_CSET_RESERVED_8  = 8,
    H5T_CSET_RESERVED_9  = 9,
    H5T_CSET_RESERVED_10 = 10,
    H5T_CSET_RESERVED_11 = 11,
    H5T_CSET_RESERVED_12 = 12,
    H5T_CSET_RESERVED_13 = 13,
    H5T_CSET_RESERVED_14 = 14,
    H5T_CSET_RESERVED_15 = 15
} H5T_cset_t;
#define H5T_NCSET H5T_CSET_RESERVED_2
typedef enum H5T_str_t {
    H5T_STR_ERROR       = -1,
    H5T_STR_NULLTERM    = 0,
    H5T_STR_NULLPAD     = 1,
    H5T_STR_SPACEPAD    = 2,
    H5T_STR_RESERVED_3  = 3,
    H5T_STR_RESERVED_4  = 4,
    H5T_STR_RESERVED_5  = 5,
    H5T_STR_RESERVED_6  = 6,
    H5T_STR_RESERVED_7  = 7,
    H5T_STR_RESERVED_8  = 8,
    H5T_STR_RESERVED_9  = 9,
    H5T_STR_RESERVED_10 = 10,
    H5T_STR_RESERVED_11 = 11,
    H5T_STR_RESERVED_12 = 12,
    H5T_STR_RESERVED_13 = 13,
    H5T_STR_RESERVED_14 = 14,
    H5T_STR_RESERVED_15 = 15
} H5T_str_t;
#define H5T_NSTR H5T_STR_RESERVED_3
//! <!-- [H5T_pad_t_snip] -->
typedef enum H5T_pad_t {
    H5T_PAD_ERROR      = -1,
    H5T_PAD_ZERO       = 0,
    H5T_PAD_ONE        = 1,
    H5T_PAD_BACKGROUND = 2,
    H5T_NPAD = 3
} H5T_pad_t;
//! <!-- [H5T_pad_t_snip] -->
//! <!-- [H5T_direction_t_snip] -->
typedef enum H5T_direction_t {
    H5T_DIR_DEFAULT = 0,
    H5T_DIR_ASCEND  = 1,
    H5T_DIR_DESCEND = 2
} H5T_direction_t;
//! <!-- [H5T_direction_t_snip] -->
typedef enum H5T_conv_except_t {
    H5T_CONV_EXCEPT_RANGE_HI = 0,
    H5T_CONV_EXCEPT_RANGE_LOW = 1,
    H5T_CONV_EXCEPT_PRECISION = 2,
    H5T_CONV_EXCEPT_TRUNCATE = 3,
    H5T_CONV_EXCEPT_PINF = 4,
    H5T_CONV_EXCEPT_NINF = 5,
    H5T_CONV_EXCEPT_NAN = 6
} H5T_conv_except_t;
typedef enum H5T_conv_ret_t {
    H5T_CONV_ABORT     = -1,
    H5T_CONV_UNHANDLED = 0,
    H5T_CONV_HANDLED   = 1
} H5T_conv_ret_t;
typedef struct {
    size_t len;
    void  *p;
} hvl_t;
#define H5T_VARIABLE SIZE_MAX
#define H5T_OPAQUE_TAG_MAX 256
#ifdef __cplusplus
extern "C" {
#endif
//! <!-- [H5T_conv_except_func_t_snip] -->
typedef H5T_conv_ret_t (*H5T_conv_except_func_t)(H5T_conv_except_t except_type, hid_t src_id, hid_t dst_id,
                                                 void *src_buf, void *dst_buf, void *user_data);
//! <!-- [H5T_conv_except_func_t_snip] -->
#undef H5OPEN
#ifndef H5private_H
#define H5OPEN H5open(),
#else
#define H5OPEN
#endif
#define H5T_IEEE_F16BE (H5OPEN H5T_IEEE_F16BE_g)
#define H5T_IEEE_F16LE (H5OPEN H5T_IEEE_F16LE_g)
#define H5T_IEEE_F32BE (H5OPEN H5T_IEEE_F32BE_g)
#define H5T_IEEE_F32LE (H5OPEN H5T_IEEE_F32LE_g)
#define H5T_IEEE_F64BE (H5OPEN H5T_IEEE_F64BE_g)
#define H5T_IEEE_F64LE (H5OPEN H5T_IEEE_F64LE_g)
H5_DLLVAR hid_t H5T_IEEE_F16BE_g;
H5_DLLVAR hid_t H5T_IEEE_F16LE_g;
H5_DLLVAR hid_t H5T_IEEE_F32BE_g;
H5_DLLVAR hid_t H5T_IEEE_F32LE_g;
H5_DLLVAR hid_t H5T_IEEE_F64BE_g;
H5_DLLVAR hid_t H5T_IEEE_F64LE_g;
#define H5T_STD_I8BE (H5OPEN H5T_STD_I8BE_g)
#define H5T_STD_I8LE (H5OPEN H5T_STD_I8LE_g)
#define H5T_STD_I16BE (H5OPEN H5T_STD_I16BE_g)
#define H5T_STD_I16LE (H5OPEN H5T_STD_I16LE_g)
#define H5T_STD_I32BE (H5OPEN H5T_STD_I32BE_g)
#define H5T_STD_I32LE (H5OPEN H5T_STD_I32LE_g)
#define H5T_STD_I64BE (H5OPEN H5T_STD_I64BE_g)
#define H5T_STD_I64LE (H5OPEN H5T_STD_I64LE_g)
#define H5T_STD_U8BE (H5OPEN H5T_STD_U8BE_g)
#define H5T_STD_U8LE (H5OPEN H5T_STD_U8LE_g)
#define H5T_STD_U16BE (H5OPEN H5T_STD_U16BE_g)
#define H5T_STD_U16LE (H5OPEN H5T_STD_U16LE_g)
#define H5T_STD_U32BE (H5OPEN H5T_STD_U32BE_g)
#define H5T_STD_U32LE (H5OPEN H5T_STD_U32LE_g)
#define H5T_STD_U64BE (H5OPEN H5T_STD_U64BE_g)
#define H5T_STD_U64LE (H5OPEN H5T_STD_U64LE_g)
#define H5T_STD_B8BE (H5OPEN H5T_STD_B8BE_g)
#define H5T_STD_B8LE (H5OPEN H5T_STD_B8LE_g)
#define H5T_STD_B16BE (H5OPEN H5T_STD_B16BE_g)
#define H5T_STD_B16LE (H5OPEN H5T_STD_B16LE_g)
#define H5T_STD_B32BE (H5OPEN H5T_STD_B32BE_g)
#define H5T_STD_B32LE (H5OPEN H5T_STD_B32LE_g)
#define H5T_STD_B64BE (H5OPEN H5T_STD_B64BE_g)
#define H5T_STD_B64LE (H5OPEN H5T_STD_B64LE_g)
#define H5T_STD_REF_OBJ (H5OPEN H5T_STD_REF_OBJ_g)
#define H5T_STD_REF_DSETREG (H5OPEN H5T_STD_REF_DSETREG_g)
#define H5T_STD_REF (H5OPEN H5T_STD_REF_g)
H5_DLLVAR hid_t H5T_STD_I8BE_g;
H5_DLLVAR hid_t H5T_STD_I8LE_g;
H5_DLLVAR hid_t H5T_STD_I16BE_g;
H5_DLLVAR hid_t H5T_STD_I16LE_g;
H5_DLLVAR hid_t H5T_STD_I32BE_g;
H5_DLLVAR hid_t H5T_STD_I32LE_g;
H5_DLLVAR hid_t H5T_STD_I64BE_g;
H5_DLLVAR hid_t H5T_STD_I64LE_g;
H5_DLLVAR hid_t H5T_STD_U8BE_g;
H5_DLLVAR hid_t H5T_STD_U8LE_g;
H5_DLLVAR hid_t H5T_STD_U16BE_g;
H5_DLLVAR hid_t H5T_STD_U16LE_g;
H5_DLLVAR hid_t H5T_STD_U32BE_g;
H5_DLLVAR hid_t H5T_STD_U32LE_g;
H5_DLLVAR hid_t H5T_STD_U64BE_g;
H5_DLLVAR hid_t H5T_STD_U64LE_g;
H5_DLLVAR hid_t H5T_STD_B8BE_g;
H5_DLLVAR hid_t H5T_STD_B8LE_g;
H5_DLLVAR hid_t H5T_STD_B16BE_g;
H5_DLLVAR hid_t H5T_STD_B16LE_g;
H5_DLLVAR hid_t H5T_STD_B32BE_g;
H5_DLLVAR hid_t H5T_STD_B32LE_g;
H5_DLLVAR hid_t H5T_STD_B64BE_g;
H5_DLLVAR hid_t H5T_STD_B64LE_g;
H5_DLLVAR hid_t H5T_STD_REF_OBJ_g;
H5_DLLVAR hid_t H5T_STD_REF_DSETREG_g;
H5_DLLVAR hid_t H5T_STD_REF_g;
#define H5T_UNIX_D32BE (H5OPEN H5T_UNIX_D32BE_g)
#define H5T_UNIX_D32LE (H5OPEN H5T_UNIX_D32LE_g)
#define H5T_UNIX_D64BE (H5OPEN H5T_UNIX_D64BE_g)
#define H5T_UNIX_D64LE (H5OPEN H5T_UNIX_D64LE_g)
H5_DLLVAR hid_t H5T_UNIX_D32BE_g;
H5_DLLVAR hid_t H5T_UNIX_D32LE_g;
H5_DLLVAR hid_t H5T_UNIX_D64BE_g;
H5_DLLVAR hid_t H5T_UNIX_D64LE_g;
#define H5T_C_S1 (H5OPEN H5T_C_S1_g)
H5_DLLVAR hid_t H5T_C_S1_g;
#define H5T_FORTRAN_S1 (H5OPEN H5T_FORTRAN_S1_g)
H5_DLLVAR hid_t H5T_FORTRAN_S1_g;
#define H5T_INTEL_I8 H5T_STD_I8LE
#define H5T_INTEL_I16 H5T_STD_I16LE
#define H5T_INTEL_I32 H5T_STD_I32LE
#define H5T_INTEL_I64 H5T_STD_I64LE
#define H5T_INTEL_U8 H5T_STD_U8LE
#define H5T_INTEL_U16 H5T_STD_U16LE
#define H5T_INTEL_U32 H5T_STD_U32LE
#define H5T_INTEL_U64 H5T_STD_U64LE
#define H5T_INTEL_B8 H5T_STD_B8LE
#define H5T_INTEL_B16 H5T_STD_B16LE
#define H5T_INTEL_B32 H5T_STD_B32LE
#define H5T_INTEL_B64 H5T_STD_B64LE
#define H5T_INTEL_F32 H5T_IEEE_F32LE
#define H5T_INTEL_F64 H5T_IEEE_F64LE
#define H5T_ALPHA_I8 H5T_STD_I8LE
#define H5T_ALPHA_I16 H5T_STD_I16LE
#define H5T_ALPHA_I32 H5T_STD_I32LE
#define H5T_ALPHA_I64 H5T_STD_I64LE
#define H5T_ALPHA_U8 H5T_STD_U8LE
#define H5T_ALPHA_U16 H5T_STD_U16LE
#define H5T_ALPHA_U32 H5T_STD_U32LE
#define H5T_ALPHA_U64 H5T_STD_U64LE
#define H5T_ALPHA_B8 H5T_STD_B8LE
#define H5T_ALPHA_B16 H5T_STD_B16LE
#define H5T_ALPHA_B32 H5T_STD_B32LE
#define H5T_ALPHA_B64 H5T_STD_B64LE
#define H5T_ALPHA_F32 H5T_IEEE_F32LE
#define H5T_ALPHA_F64 H5T_IEEE_F64LE
#define H5T_MIPS_I8 H5T_STD_I8BE
#define H5T_MIPS_I16 H5T_STD_I16BE
#define H5T_MIPS_I32 H5T_STD_I32BE
#define H5T_MIPS_I64 H5T_STD_I64BE
#define H5T_MIPS_U8 H5T_STD_U8BE
#define H5T_MIPS_U16 H5T_STD_U16BE
#define H5T_MIPS_U32 H5T_STD_U32BE
#define H5T_MIPS_U64 H5T_STD_U64BE
#define H5T_MIPS_B8 H5T_STD_B8BE
#define H5T_MIPS_B16 H5T_STD_B16BE
#define H5T_MIPS_B32 H5T_STD_B32BE
#define H5T_MIPS_B64 H5T_STD_B64BE
#define H5T_MIPS_F32 H5T_IEEE_F32BE
#define H5T_MIPS_F64 H5T_IEEE_F64BE
#define H5T_VAX_F32 (H5OPEN H5T_VAX_F32_g)
#define H5T_VAX_F64 (H5OPEN H5T_VAX_F64_g)
H5_DLLVAR hid_t H5T_VAX_F32_g;
H5_DLLVAR hid_t H5T_VAX_F64_g;
#define H5T_NATIVE_CHAR (CHAR_MIN ? H5T_NATIVE_SCHAR : H5T_NATIVE_UCHAR)
#define H5T_NATIVE_SCHAR (H5OPEN H5T_NATIVE_SCHAR_g)
#define H5T_NATIVE_UCHAR (H5OPEN H5T_NATIVE_UCHAR_g)
#define H5T_NATIVE_SHORT (H5OPEN H5T_NATIVE_SHORT_g)
#define H5T_NATIVE_USHORT (H5OPEN H5T_NATIVE_USHORT_g)
#define H5T_NATIVE_INT (H5OPEN H5T_NATIVE_INT_g)
#define H5T_NATIVE_UINT (H5OPEN H5T_NATIVE_UINT_g)
#define H5T_NATIVE_LONG (H5OPEN H5T_NATIVE_LONG_g)
#define H5T_NATIVE_ULONG (H5OPEN H5T_NATIVE_ULONG_g)
#define H5T_NATIVE_LLONG (H5OPEN H5T_NATIVE_LLONG_g)
#define H5T_NATIVE_ULLONG (H5OPEN H5T_NATIVE_ULLONG_g)
#define H5T_NATIVE_FLOAT16 (H5OPEN H5T_NATIVE_FLOAT16_g)
#define H5T_NATIVE_FLOAT (H5OPEN H5T_NATIVE_FLOAT_g)
#define H5T_NATIVE_DOUBLE (H5OPEN H5T_NATIVE_DOUBLE_g)
#define H5T_NATIVE_LDOUBLE (H5OPEN H5T_NATIVE_LDOUBLE_g)
#define H5T_NATIVE_B8 (H5OPEN H5T_NATIVE_B8_g)
#define H5T_NATIVE_B16 (H5OPEN H5T_NATIVE_B16_g)
#define H5T_NATIVE_B32 (H5OPEN H5T_NATIVE_B32_g)
#define H5T_NATIVE_B64 (H5OPEN H5T_NATIVE_B64_g)
#define H5T_NATIVE_OPAQUE (H5OPEN H5T_NATIVE_OPAQUE_g)
#define H5T_NATIVE_HADDR (H5OPEN H5T_NATIVE_HADDR_g)
#define H5T_NATIVE_HSIZE (H5OPEN H5T_NATIVE_HSIZE_g)
#define H5T_NATIVE_HSSIZE (H5OPEN H5T_NATIVE_HSSIZE_g)
#define H5T_NATIVE_HERR (H5OPEN H5T_NATIVE_HERR_g)
#define H5T_NATIVE_HBOOL (H5OPEN H5T_NATIVE_HBOOL_g)
H5_DLLVAR hid_t H5T_NATIVE_SCHAR_g;
H5_DLLVAR hid_t H5T_NATIVE_UCHAR_g;
H5_DLLVAR hid_t H5T_NATIVE_SHORT_g;
H5_DLLVAR hid_t H5T_NATIVE_USHORT_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT_g;
H5_DLLVAR hid_t H5T_NATIVE_LONG_g;
H5_DLLVAR hid_t H5T_NATIVE_ULONG_g;
H5_DLLVAR hid_t H5T_NATIVE_LLONG_g;
H5_DLLVAR hid_t H5T_NATIVE_ULLONG_g;
H5_DLLVAR hid_t H5T_NATIVE_FLOAT16_g;
H5_DLLVAR hid_t H5T_NATIVE_FLOAT_g;
H5_DLLVAR hid_t H5T_NATIVE_DOUBLE_g;
H5_DLLVAR hid_t H5T_NATIVE_LDOUBLE_g;
H5_DLLVAR hid_t H5T_NATIVE_B8_g;
H5_DLLVAR hid_t H5T_NATIVE_B16_g;
H5_DLLVAR hid_t H5T_NATIVE_B32_g;
H5_DLLVAR hid_t H5T_NATIVE_B64_g;
H5_DLLVAR hid_t H5T_NATIVE_OPAQUE_g;
H5_DLLVAR hid_t H5T_NATIVE_HADDR_g;
H5_DLLVAR hid_t H5T_NATIVE_HSIZE_g;
H5_DLLVAR hid_t H5T_NATIVE_HSSIZE_g;
H5_DLLVAR hid_t H5T_NATIVE_HERR_g;
H5_DLLVAR hid_t H5T_NATIVE_HBOOL_g;
#define H5T_NATIVE_INT8 (H5OPEN H5T_NATIVE_INT8_g)
#define H5T_NATIVE_UINT8 (H5OPEN H5T_NATIVE_UINT8_g)
#define H5T_NATIVE_INT_LEAST8 (H5OPEN H5T_NATIVE_INT_LEAST8_g)
#define H5T_NATIVE_UINT_LEAST8 (H5OPEN H5T_NATIVE_UINT_LEAST8_g)
#define H5T_NATIVE_INT_FAST8 (H5OPEN H5T_NATIVE_INT_FAST8_g)
#define H5T_NATIVE_UINT_FAST8 (H5OPEN H5T_NATIVE_UINT_FAST8_g)
H5_DLLVAR hid_t H5T_NATIVE_INT8_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT8_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_LEAST8_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT_LEAST8_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_FAST8_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT_FAST8_g;
#define H5T_NATIVE_INT16 (H5OPEN H5T_NATIVE_INT16_g)
#define H5T_NATIVE_UINT16 (H5OPEN H5T_NATIVE_UINT16_g)
#define H5T_NATIVE_INT_LEAST16 (H5OPEN H5T_NATIVE_INT_LEAST16_g)
#define H5T_NATIVE_UINT_LEAST16 (H5OPEN H5T_NATIVE_UINT_LEAST16_g)
#define H5T_NATIVE_INT_FAST16 (H5OPEN H5T_NATIVE_INT_FAST16_g)
#define H5T_NATIVE_UINT_FAST16 (H5OPEN H5T_NATIVE_UINT_FAST16_g)
H5_DLLVAR hid_t H5T_NATIVE_INT16_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT16_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_LEAST16_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT_LEAST16_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_FAST16_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT_FAST16_g;
#define H5T_NATIVE_INT32 (H5OPEN H5T_NATIVE_INT32_g)
#define H5T_NATIVE_UINT32 (H5OPEN H5T_NATIVE_UINT32_g)
#define H5T_NATIVE_INT_LEAST32 (H5OPEN H5T_NATIVE_INT_LEAST32_g)
#define H5T_NATIVE_UINT_LEAST32 (H5OPEN H5T_NATIVE_UINT_LEAST32_g)
#define H5T_NATIVE_INT_FAST32 (H5OPEN H5T_NATIVE_INT_FAST32_g)
#define H5T_NATIVE_UINT_FAST32 (H5OPEN H5T_NATIVE_UINT_FAST32_g)
H5_DLLVAR hid_t H5T_NATIVE_INT32_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT32_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_LEAST32_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT_LEAST32_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_FAST32_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT_FAST32_g;
#define H5T_NATIVE_INT64 (H5OPEN H5T_NATIVE_INT64_g)
#define H5T_NATIVE_UINT64 (H5OPEN H5T_NATIVE_UINT64_g)
#define H5T_NATIVE_INT_LEAST64 (H5OPEN H5T_NATIVE_INT_LEAST64_g)
#define H5T_NATIVE_UINT_LEAST64 (H5OPEN H5T_NATIVE_UINT_LEAST64_g)
#define H5T_NATIVE_INT_FAST64 (H5OPEN H5T_NATIVE_INT_FAST64_g)
#define H5T_NATIVE_UINT_FAST64 (H5OPEN H5T_NATIVE_UINT_FAST64_g)
H5_DLLVAR hid_t H5T_NATIVE_INT64_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT64_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_LEAST64_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT_LEAST64_g;
H5_DLLVAR hid_t H5T_NATIVE_INT_FAST64_g;
H5_DLLVAR hid_t H5T_NATIVE_UINT_FAST64_g;
H5_DLL hid_t H5Tcreate(H5T_class_t type, size_t size);
H5_DLL hid_t H5Tcopy(hid_t type_id);
H5_DLL herr_t H5Tclose(hid_t type_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Tclose_async(const char *app_file, const char *app_func, unsigned app_line, hid_t type_id,
                             hid_t es_id);
#else
H5_DLL herr_t H5Tclose_async(hid_t type_id, hid_t es_id);
#endif
H5_DLL htri_t H5Tequal(hid_t type1_id, hid_t type2_id);
H5_DLL herr_t H5Tlock(hid_t type_id);
H5_DLL herr_t H5Tcommit2(hid_t loc_id, const char *name, hid_t type_id, hid_t lcpl_id, hid_t tcpl_id,
                         hid_t tapl_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Tcommit_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                              const char *name, hid_t type_id, hid_t lcpl_id, hid_t tcpl_id, hid_t tapl_id,
                              hid_t es_id);
#else
H5_DLL herr_t H5Tcommit_async(hid_t loc_id, const char *name, hid_t type_id, hid_t lcpl_id, hid_t tcpl_id,
                              hid_t tapl_id, hid_t es_id);
#endif
H5_DLL hid_t H5Topen2(hid_t loc_id, const char *name, hid_t tapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Topen_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                           const char *name, hid_t tapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Topen_async(hid_t loc_id, const char *name, hid_t tapl_id, hid_t es_id);
#endif
H5_DLL herr_t H5Tcommit_anon(hid_t loc_id, hid_t type_id, hid_t tcpl_id, hid_t tapl_id);
H5_DLL hid_t H5Tget_create_plist(hid_t type_id);
H5_DLL htri_t H5Tcommitted(hid_t type_id);
H5_DLL herr_t H5Tencode(hid_t obj_id, void *buf, size_t *nalloc);
H5_DLL hid_t H5Tdecode(const void *buf);
H5_DLL herr_t H5Tflush(hid_t type_id);
H5_DLL herr_t H5Trefresh(hid_t type_id);
H5_DLL herr_t H5Tinsert(hid_t parent_id, const char *name, size_t offset, hid_t member_id);
H5_DLL herr_t H5Tpack(hid_t type_id);
H5_DLL hid_t H5Tenum_create(hid_t base_id);
H5_DLL herr_t H5Tenum_insert(hid_t type, const char *name, const void *value);
H5_DLL herr_t H5Tenum_nameof(hid_t type, const void *value, char *name, size_t size);
H5_DLL herr_t H5Tenum_valueof(hid_t type, const char *name, void *value);
H5_DLL hid_t H5Tvlen_create(hid_t base_id);
H5_DLL hid_t H5Tarray_create2(hid_t base_id, unsigned ndims, const hsize_t dim[]);
H5_DLL int H5Tget_array_ndims(hid_t type_id);
H5_DLL int H5Tget_array_dims2(hid_t type_id, hsize_t dims[]);
H5_DLL herr_t H5Tset_tag(hid_t type, const char *tag);
H5_DLL char *H5Tget_tag(hid_t type);
H5_DLL hid_t H5Tget_super(hid_t type);
H5_DLL H5T_class_t H5Tget_class(hid_t type_id);
H5_DLL htri_t H5Tdetect_class(hid_t type_id, H5T_class_t cls);
H5_DLL size_t H5Tget_size(hid_t type_id);
H5_DLL H5T_order_t H5Tget_order(hid_t type_id);
H5_DLL size_t H5Tget_precision(hid_t type_id);
H5_DLL int H5Tget_offset(hid_t type_id);
H5_DLL herr_t H5Tget_pad(hid_t type_id, H5T_pad_t *lsb, H5T_pad_t *msb);
H5_DLL H5T_sign_t H5Tget_sign(hid_t type_id);
H5_DLL herr_t H5Tget_fields(hid_t type_id, size_t *spos, size_t *epos, size_t *esize,
                            size_t *mpos, size_t *msize);
H5_DLL size_t H5Tget_ebias(hid_t type_id);
H5_DLL H5T_norm_t H5Tget_norm(hid_t type_id);
H5_DLL H5T_pad_t H5Tget_inpad(hid_t type_id);
H5_DLL H5T_str_t H5Tget_strpad(hid_t type_id);
H5_DLL int H5Tget_nmembers(hid_t type_id);
H5_DLL char *H5Tget_member_name(hid_t type_id, unsigned membno);
H5_DLL int H5Tget_member_index(hid_t type_id, const char *name);
H5_DLL size_t H5Tget_member_offset(hid_t type_id, unsigned membno);
H5_DLL H5T_class_t H5Tget_member_class(hid_t type_id, unsigned membno);
H5_DLL hid_t H5Tget_member_type(hid_t type_id, unsigned membno);
H5_DLL herr_t H5Tget_member_value(hid_t type_id, unsigned membno, void *value);
H5_DLL H5T_cset_t H5Tget_cset(hid_t type_id);
H5_DLL htri_t H5Tis_variable_str(hid_t type_id);
H5_DLL hid_t H5Tget_native_type(hid_t type_id, H5T_direction_t direction);
H5_DLL herr_t H5Tset_size(hid_t type_id, size_t size);
H5_DLL herr_t H5Tset_order(hid_t type_id, H5T_order_t order);
H5_DLL herr_t H5Tset_precision(hid_t type_id, size_t prec);
H5_DLL herr_t H5Tset_offset(hid_t type_id, size_t offset);
H5_DLL herr_t H5Tset_pad(hid_t type_id, H5T_pad_t lsb, H5T_pad_t msb);
H5_DLL herr_t H5Tset_sign(hid_t type_id, H5T_sign_t sign);
H5_DLL herr_t H5Tset_fields(hid_t type_id, size_t spos, size_t epos, size_t esize, size_t mpos, size_t msize);
H5_DLL herr_t H5Tset_ebias(hid_t type_id, size_t ebias);
H5_DLL herr_t H5Tset_norm(hid_t type_id, H5T_norm_t norm);
H5_DLL herr_t H5Tset_inpad(hid_t type_id, H5T_pad_t pad);
H5_DLL herr_t H5Tset_cset(hid_t type_id, H5T_cset_t cset);
H5_DLL herr_t H5Tset_strpad(hid_t type_id, H5T_str_t strpad);
H5_DLL herr_t H5Tconvert(hid_t src_id, hid_t dst_id, size_t nelmts, void *buf, void *background,
                         hid_t plist_id);
H5_DLL herr_t H5Treclaim(hid_t type_id, hid_t space_id, hid_t plist_id, void *buf);
#ifndef H5T_MODULE
#define H5Tcommit_async(...) H5Tcommit_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Topen_async(...)   H5Topen_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Tclose_async(...)  H5Tclose_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Tcommit_async_wrap H5_NO_EXPAND(H5Tcommit_async)
#define H5Topen_async_wrap   H5_NO_EXPAND(H5Topen_async)
#define H5Tclose_async_wrap  H5_NO_EXPAND(H5Tclose_async)
#endif
#ifndef H5_NO_DEPRECATED_SYMBOLS
H5_DLL herr_t H5Tcommit1(hid_t loc_id, const char *name, hid_t type_id);
H5_DLL hid_t H5Topen1(hid_t loc_id, const char *name);
H5_DLL hid_t H5Tarray_create1(hid_t base_id, int ndims, const hsize_t dim[],
                              const int perm[]);
H5_DLL int H5Tget_array_dims1(hid_t type_id, hsize_t dims[], int perm[]);
#endif
#ifdef __cplusplus
}
#endif
#endif
