% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilma.R
\name{mediate_hilma}
\alias{mediate_hilma}
\title{High-Dimensional Linear Mediation Analysis}
\usage{
mediate_hilma(
  A,
  M,
  Y,
  aic_tuning = FALSE,
  nlambda = 5,
  lambda_minmax_ratio = 0.1,
  center = TRUE
)
}
\arguments{
\item{A}{length \code{n} numeric vector containing a single exposure variable
or size \code{n x q} numeric matrix containing multiple exposures. If a matrix,
should be low-dimensional (\code{q << n}).}

\item{M}{\code{n x p} numeric matrix of high-dimensional mediators.}

\item{Y}{length \code{n} numeric vector containing continuous outcome variable.}

\item{aic_tuning}{logical flag for whether to select the tuning parameter using
AIC. Default is \code{FALSE} as this was not the preferred approach by the
HILMA authors (see references for more detail).}

\item{nlambda}{number of candidate lambdas for AIC tuning. Default is 5. If
\code{aic_tuning=F} this parameter is ignored.}

\item{lambda_minmax_ratio}{ratio of the minimum lambda attempted in
AIC tuning to the maximum. If \code{aic_tuning=F}, ignored.}

\item{center}{logical flag for whether the variables should be centered. Default
is \code{TRUE}.}
}
\value{
A list containing, for each exposure, a data frame of
the estimated direct, total, and global mediation effects. A p-value is
provided for the global mediation effect.
}
\description{
\code{mediate_hilma} applies high-dimensional linear mediation
analysis (HILMA) as proposed by Zhou et al. (2020).
}
\details{
\code{mediate_hilma} is a wrapper function for the \code{\link[freebird:hilma]{freebird::hilma()}} function,
which fits the "high-dimensional linear mediation analysis" model proposed by
Zhou et al. (2020) for mediation settings when there are high-dimensional
mediators and one or several exposures. The function returns estimates of
the direct effect, total effect, and global mediation effect, the last of which
is tested for statistical significance with a reported p-value. For additional
detail, see the attached reference as well as the \code{\link[freebird:hilma]{freebird::hilma()}}
documentation.
}
\examples{
A <- med_dat$A
M <- med_dat$M
Y <- med_dat$Y

# Implement HILMA with one exposure
out <- mediate_hilma(A, M, Y)
out$a1



}
\references{
Zhou, R. R., Wang, L. & Zhao, S. D. Estimation and inference for
the indirect effect in high-dimensional linear mediation models. Biometrika
107, 573-589 (2020)
}
