% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_n.R
\name{report_n}
\alias{report_n}
\title{Report number of distinct value in a column across data frames}
\usage{
report_n(..., on, force_proceed = getOption("healthdb.force_proceed"))
}
\arguments{
\item{...}{Data frames or remote tables (e.g., from 'dbplyr')}

\item{on}{The column to report on. It must be present in all data sources.}

\item{force_proceed}{A logical for whether to ask for user input in order to proceed when the data is not local data.frames, and a query needs to be executed before reporting. The default is fetching from options (FALSE). Use \code{options(healthdb.force_proceed = TRUE)} to suppress the prompt once and for all.}
}
\value{
A sequence of the number of distinct \code{on} for each data frames
}
\description{
This function is intended to mimic \code{\link[dplyr:n_distinct]{dplyr::n_distinct()}} for multiple inputs. It is useful to report the number of clients through out a series of inclusion or exclusion steps. An use case could be getting the Ns for the sample definition flowchart in an epidemiological study. It is also useful for inline reporting of Ns in a Rmarkdown document.
}
\examples{
# some exclusions
iris_1 <- subset(iris, Petal.Length > 1)
iris_2 <- subset(iris, Petal.Length > 2)

# get n at each operation
n <- report_n(iris, iris_1, iris_2, on = Species)
n

# get the difference at each step
diff(n)
# data in a list
iris_list <- list(iris_1, iris_2)
report_n(rlang::splice(iris_list), on = Species)
# if you loaded tidyverse, this will also work
# report_n(!!!iris_list, on = Species)
}
