% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_ceplane}
\alias{plot_ceplane}
\title{Plot cost-effectiveness plane}
\usage{
plot_ceplane(x, k = 50000, labels = NULL)
}
\arguments{
\item{x}{A \code{cea_pw} object produced by \code{\link[=cea_pw]{cea_pw()}}.}

\item{k}{Willingness to pay per QALY.}

\item{labels}{A list of named vectors containing the values and labels of
variables. The elements of each vector are the values of a variable and the
names are the labels. The names of the list are the names of the variables.
See the output returned by \code{\link[=get_labels]{get_labels()}} for an example.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot a cost-effectiveness plane from the output of \code{\link[=cea_pw]{cea_pw()}} using \code{\link[ggplot2:ggplot]{ggplot2::ggplot}}.
Each point is a random draw of incremental costs (y-axis) and incremental QALYs (x-axis)
from a probabilistic sensitivity analysis.
}
\details{
See the \code{\link[=cea_pw]{cea_pw()}} documentation for an example. If there are multiple subgroups,
then a faceted plot is produced with one plot for each subgroup.
}
