% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dggrid_compat.R
\name{as_dggrid}
\alias{as_dggrid}
\title{Convert hexify grid to 'dggridR'-compatible grid object}
\usage{
as_dggrid(grid)
}
\arguments{
\item{grid}{A hexify_grid object from hexify_grid()}
}
\value{
A list with 'dggridR'-compatible fields:
\item{pole_lon_deg}{Longitude of grid pole (default 11.25)}
\item{pole_lat_deg}{Latitude of grid pole (default 58.28252559)}
\item{azimuth_deg}{Grid azimuth rotation (default 0)}
\item{aperture}{Grid aperture (3, 4, or 7)}
\item{res}{Resolution level}
\item{topology}{Grid topology ("HEXAGON")}
\item{projection}{Map projection ('ISEA')}
\item{precision}{Output decimal precision (default 7)}
}
\description{
Creates a 'dggridR'-compatible grid specification from a hexify_grid object.
The resulting object can be used with 'dggridR' functions that accept a dggs
object.
}
\seealso{
Other 'dggridR' compatibility: 
\code{\link{dggrid_43h_sequence}()},
\code{\link{dggrid_is_compatible}()},
\code{\link{from_dggrid}()}
}
\concept{'dggridR' compatibility}
