% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_stats.R
\name{dgearthstat}
\alias{dgearthstat}
\title{Get grid statistics for Earth coverage}
\usage{
dgearthstat(dggs)
}
\arguments{
\item{dggs}{Grid specification from hexify_grid()}
}
\value{
List with components:
\item{area_km}{Total Earth surface area in km^2}
\item{n_cells}{Total number of cells at this resolution}
\item{cell_area_km2}{Average cell area in km^2}
\item{cell_spacing_km}{Average distance between cell centers in km}
\item{resolution}{Resolution level}
\item{aperture}{Grid aperture}
}
\description{
Calculates statistics about the hexagonal grid at the current resolution,
including total number of cells, cell area, and cell spacing.
}
\examples{
grid <- hexify_grid(area = 1000, aperture = 3)
stats <- dgearthstat(grid)

print(sprintf("Resolution \%d has \%.0f cells",
              stats$resolution, stats$n_cells))
print(sprintf("Average cell area: \%.2f km^2",
              stats$cell_area_km2))
print(sprintf("Average cell spacing: \%.2f km",
              stats$cell_spacing_km))
}
\seealso{
Other grid statistics: 
\code{\link{dg_closest_res_to_area}()},
\code{\link{hexify_area_to_eff_res}()},
\code{\link{hexify_compare_resolutions}()},
\code{\link{hexify_eff_res_to_area}()},
\code{\link{hexify_eff_res_to_resolution}()},
\code{\link{hexify_resolution_to_eff_res}()}
}
\concept{grid statistics}
