% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot,HexData,missing-method}
\alias{plot,HexData,missing-method}
\title{Plot HexData objects}
\usage{
\S4method{plot}{HexData,missing}(
  x,
  y,
  basemap = TRUE,
  clip_basemap = TRUE,
  basemap_fill = "gray90",
  basemap_border = "gray50",
  basemap_lwd = 0.5,
  grid_fill = "#E69F00",
  grid_border = "#5D4E37",
  grid_lwd = 0.8,
  grid_alpha = 0.7,
  fill = NULL,
  show_points = FALSE,
  point_size = "auto",
  point_color = "red",
  crop = TRUE,
  crop_expand = 0.1,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{A HexData object from \code{hexify()}}

\item{y}{Ignored (for S4 method compatibility)}

\item{basemap}{Basemap specification:
\itemize{
\item \code{TRUE} or \code{"world"}: Use built-in world map
\item \code{FALSE} or \code{NULL}: No basemap
\item sf object: Custom basemap
}}

\item{clip_basemap}{Clip basemap to data extent (default TRUE). Clipping
temporarily disables S2 spherical geometry to avoid edge-crossing errors.}

\item{basemap_fill}{Fill color for basemap (default "gray90")}

\item{basemap_border}{Border color for basemap (default "gray50")}

\item{basemap_lwd}{Line width for basemap borders (default 0.5)}

\item{grid_fill}{Fill color for grid cells (default "#E69F00" - amber/orange)}

\item{grid_border}{Border color for grid cells (default "#5D4E37" - dark brown)}

\item{grid_lwd}{Line width for cell borders (default 0.8)}

\item{grid_alpha}{Transparency for cell fill (0-1, default 0.7)}

\item{fill}{Column name for fill mapping (optional)}

\item{show_points}{Show original points on top of cells (default FALSE).
Points are jittered within their assigned hexagon.}

\item{point_size}{Size of points. Can be:
\itemize{
\item A number (direct cex value)
\item A preset defining what fraction of a hex cell one point covers:
"tiny" (~2\\%), "small" (~5\\%), "normal"/"auto" (~10\\%),
"large" (~20\\%), "very large" (~35\\%)
}}

\item{point_color}{Color of points (default "red")}

\item{crop}{Crop to data extent (default TRUE)}

\item{crop_expand}{Expansion factor for crop (default 0.1)}

\item{main}{Plot title}

\item{...}{Additional arguments passed to base plot()}
}
\value{
Invisibly returns the HexData object
}
\description{
Default plot method for HexData objects. Draws hexagonal grid cells
with an optional basemap.
}
\details{
This function generates polygon geometries for the cells present in
the data and plots them. Polygons are computed on demand, not stored,
to minimize memory usage.
}
\examples{
\donttest{
df <- data.frame(lon = runif(50, -5, 5), lat = runif(50, 45, 50))
result <- hexify(df, lon = "lon", lat = "lat", area_km2 = 2000)

# Basic plot
plot(result, basemap = FALSE)

# With basemap and custom styling
plot(result, grid_fill = "lightblue", grid_border = "darkblue")
}
}
\seealso{
\code{\link{hexify_heatmap}} for ggplot2 plotting
}
