% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{aggregateQuotes}
\alias{aggregateQuotes}
\title{Aggregate a \code{data.table} or \code{xts} object containing quote data}
\usage{
aggregateQuotes(
  qData,
  alignBy = "minutes",
  alignPeriod = 5,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  tz = NULL
)
}
\arguments{
\item{qData}{\code{data.table} or \code{xts} object to be aggregated, containing the intraday quote data of a stock for one day.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. Possible values are: "secs", "seconds", "mins", "minutes","hours", and "ticks".
To aggregate based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. E.g. to aggregate
based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{marketOpen}{the market opening time, by default: \code{marketOpen = "09:30:00"}.}

\item{marketClose}{the market closing time, by default: \code{marketClose = "16:00:00"}.}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. We attempt to extract the timezone from the DT column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}}
}
\value{
A \code{data.table} or an \code{xts} object containing the aggregated quote data.
}
\description{
Aggregate tick-by-tick quote data and return a \code{data.table} or \code{xts} object containing the aggregated quote data.
See \code{\link{sampleQData}} for an example of the argument qData. This function accepts arbitrary number of symbols over an arbitrary number of days.
}
\details{
The output "BID" and "OFR" columns are constructed using previous tick aggregation.

The variables "BIDSIZ" and "OFRSIZ" are aggregated by taking the sum of the respective inputs over each interval.

The timestamps of the new time series are the closing times of the intervals. 

Please note: Returned objects always contain the first observation (i.e. opening quotes,...).
}
\examples{
# Aggregate quote data to the 30 second frequency
qDataAggregated <- aggregateQuotes(sampleQData, alignBy = "seconds", alignPeriod = 30)
qDataAggregated # Show the aggregated data
}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{data}
\keyword{manipulation}
