% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiwaveplot.R
\name{wave_dependencies}
\alias{wave_dependencies}
\title{Multiple Wave Inputs vs Outputs}
\usage{
wave_dependencies(
  waves,
  targets,
  output_names = names(targets),
  input_names = names(waves[[1]])[!names(waves[[1]]) \%in\% names(targets)],
  p_size = 1.5,
  l_wid = 1.5,
  normalize = FALSE,
  zero_in = TRUE,
  wave_numbers = ifelse(zero_in, 0, 1):(length(waves) - ifelse(zero_in, 1, 0)),
  ...
)
}
\arguments{
\item{waves}{The list of data.frame objects, one for each set of outputs at that wave.}

\item{targets}{The target values of the outputs.}

\item{output_names}{The outputs to plot, if not all are wanted.}

\item{input_names}{The inputs to plot, if not all are wanted.}

\item{p_size}{Control for the point size on the plots: smaller is better for many plots.}

\item{l_wid}{Control for line width of superimposed targets.}

\item{normalize}{If true, plotting is done with target bounds equal size.}

\item{zero_in}{Is a wave 0 included in the waves list?}

\item{wave_numbers}{Which waves to plot}

\item{...}{Optional parameters (not to be used directly)}
}
\value{
A grid of ggplot objects.
}
\description{
Given multiple waves of points, produce input-output plots for each pair.
}
\details{
It can be useful to consider what the dependencies between the input values and output
values are, to investigate the suitability of the chosen input ranges (i.e. if widening
an input range could result in the targets being matchable). This function provides those
plots.

For each output-input pair, a points plot is produced with the input value on the x-axis
and the output value on the y-axis. The target bounds are superimposed as horizontal lines.
The points themselves are coloured by which wave of history matching they came from.

These can show dependencies between specific outputs and inputs and, if points are clustering
at the far left or right edge of a plot, can give an indication that the input ranges are
unsuitable for matching the target.
}
\examples{
 wave_dependencies(SIRMultiWaveData, SIREmulators$targets, l_wid = 0.8, p_size = 0.8)
 wave_dependencies(SIRMultiWaveData, SIREmulators$targets, c('nS', 'nI'), c('aIR', 'aSI'))
 \donttest{
     # For many plots, it may be helpful to manually modify the font size
     wave_dependencies(SIRMultiWaveData, SIREmulators$targets) +
      ggplot2::theme(text = ggplot2::element_text(size = 5))
 }
}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{hit_by_wave}()},
\code{\link{output_plot}()},
\code{\link{plot_actives}()},
\code{\link{plot_lattice}()},
\code{\link{plot_wrap}()},
\code{\link{simulator_plot}()},
\code{\link{space_removed}()},
\code{\link{validation_pairs}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
