% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyGapfill.R
\name{applyGapfill}
\alias{applyGapfill}
\title{Gapfilling for Earth Observation datasets}
\usage{
applyGapfill(
  inputDir,
  outputDir,
  progressDir,
  lat,
  lon,
  days,
  years,
  numCores = 6,
  scale = 1e-04,
  clipRange = c(-1, 1),
  addArgToReport = TRUE
)
}
\arguments{
\item{inputDir}{character. Full path name of directory containing files configured
to be processed with \code{\link[gapfill]{Gapfill}}. See \bold{Note}.}

\item{outputDir}{character. Full path name of directory where output will be saved.
See \bold{Note}.}

\item{progressDir}{character. Full path name of directory where a file reporting on the
status of the process will be saved. See \bold{Note}.}

\item{lat}{character vector. See \code{\link[igapfill]{get_LAT}}.}

\item{lon}{character vector. See \code{\link[igapfill]{get_LON}}.}

\item{days}{numeric vector indicating what days are being considered. See \code{\link[igapfill]{get_4Darray}}.}

\item{years}{integer vector indicating what years are being considered. See \code{\link[igapfill]{get_4Darray}}.}

\item{numCores}{numeric. How many cores should be employed in parallel computing?}

\item{scale}{numeric. See \code{\link[gapfill]{Gapfill}}. Default is \code{1e-4}. See \bold{Note}.}

\item{clipRange}{numeric vector of length 2. See \code{\link[gapfill]{Gapfill}}. Default is
\code{c(-1,1)}. See \bold{Note}.}

\item{addArgToReport}{logical. Should a copy of the input arguments be passed onto the progress
report file? Default is \code{TRUE}.}
}
\value{
Should the user decide to employ this function, at the output directory (\code{outputDir})
there will be \code{.RData} files containing the output of parallel-based calls to \code{\link[gapfill]{Gapfill}}.
There will be as many \code{.RData} files as files are in any of the sub-directories indicated by
\code{inputDir}.
}
\description{
Making use of parallel computing this function allows for the application
of \code{\link[gapfill]{Gapfill}} to a set of satellite images. It is mandatory
that these images have been configured for processing according to the
workflow of this package previously.
}
\details{
Should the users have not yet created it, this function allows to create the 
directory/folders structure employed by this package workflow. When users opt for creating such
a directory structure, additional arguments are required at the console. When users acknowledge 
the existence of such directory structure or when they decide to create such structure independently,
this function returns the message \emph{"Try again later passing the required parameters"}.
}
\note{
Within the workflow of this package, \code{inputDir}, \code{outputDir} and
\code{progressDir} must be equal to the sub-directories \emph{/splits}, 
\emph{/output}, and \emph{/progressReports}, created by \code{\link[igapfill]{create_dirs}},
respectively. Many satellite products come with a scale factor of \code{1e4}, using
\code{scale=1e-4} maps pixel values to the interval \code{(-1,1)} which is the default for
argument \code{clipRange}.
}
\seealso{
\code{\link[igapfill]{create_dirs}}, \code{\link[foreach]{foreach}}, \code{\link[gapfill]{Gapfill}}, 
\code{\link[parallel]{makeCluster}}, \code{\link[doParallel]{registerDoParallel}}
}
