% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlecell.R
\name{select_clusters}
\alias{select_clusters}
\title{Split the immune repertoire data to clusters from single-cell barcodes}
\usage{
select_clusters(.data, .clusters, .field = "Cluster")
}
\arguments{
\item{.data}{List of two elements "data" and "meta", with "data" being a list of
immune repertoires, and "meta" being a metadata table.}

\item{.clusters}{Factor vector with barcodes as vector names and cluster IDs as vector elements.
The output of the Seurat \code{Idents} function works.}

\item{.field}{A string specifying the name of the field in the input metadata. New immune
repertoire subsets will have cluster IDs in this field.}
}
\value{
A list with two elements "data" and "meta" with updated immune repertoire tables and
metadata.
}
\description{
Given the vector of barcodes from Seurat, splits the input repertoires
to separate subsets following the barcodes' assigned IDs. Useful in case you want to
split immune repertoires by patients or clusters.
}
\examples{
\dontrun{
library(Seurat)
Idents(pbmc_small)
new_cluster_ids <- c("A", "B", "C")
new_cluster_ids <- levels(pbmc_small)
new_cluster_ids
pbmc_small <- RenameIdents(pbmc_small, new_cluster_ids)
}
}
\seealso{
\link{select_barcodes}
}
\concept{single_cell}
