% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cheesecake.R
\name{cheesecake}
\alias{cheesecake}
\title{cheesecake: Population disaggregation by two-level demographic groups (eg., age and sex), with covariates}
\usage{
cheesecake(df, output_dir, verbose = TRUE)
}
\arguments{
\item{df}{A data frame object containing sample data (often partially observed) on age and sex groups population data, for example,
as well as the overall total population counts per administrative unit.}

\item{output_dir}{This is the directory with the name of the output folder where the
disaggregated population proportions and population totals are
automatically saved.}

\item{verbose}{Logical. If TRUE (default), progress messages are displayed during model execution.
Set to FALSE to suppress informational messages.}
}
\value{
A list of data frame objects of the output files including the disaggregated population proportions and population totals
along with the corresponding measures of uncertainties (lower and upper bounds of 95-percent credible intervals) for each demographic characteristic.
In addition, a file containing the model performance/model fit evaluation metrics is also produced.
}
\description{
Used to disaggregate small area population estimates by age, sex, and
other socio-demographic or socio-economic characteristics (e.g., ethnicity, religion, educational level, immigration status, etc).

It uses Bayesian hierachical statistical models to predict population proportions and population totals across demographic groups.
Primarily designed to support users (e.g., National Statistical Offices) in filling population data gaps across various demographic groups due to outdated or incomplete census/population data.
}
\examples{
\donttest{
if (requireNamespace("INLA", quietly = TRUE)) {
 data(toydata)
 result <- cheesecake(df = toydata$admin, output_dir = tempdir())
}
}
}
