% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning_functions.R
\name{keep_non_null_rows}
\alias{keep_non_null_rows}
\title{Pruning Function to accommodate removal of completely NULL rows within a table}
\usage{
keep_non_null_rows(tr)
}
\arguments{
\item{tr}{table tree object}
}
\value{
a function that can be utilized as a row_condition in the tern::keep_rows function
}
\description{
Condition function on individual analysis rows. Flag as FALSE when all
columns are NULL, as then the row should not be kept. To be utilized as a
row_condition in function tern::keep_rows
}
\examples{

library(dplyr)

ADSL <- data.frame(
  USUBJID = c(
    "XXXXX01", "XXXXX02", "XXXXX03", "XXXXX04", "XXXXX05",
    "XXXXX06", "XXXXX07", "XXXXX08", "XXXXX09", "XXXXX10"
  ),
  TRT01P = c(
    "ARMA", "ARMB", "ARMA", "ARMB", "ARMB", "Placebo",
    "Placebo", "Placebo", "ARMA", "ARMB"
  ),
  AGE = c(34, 56, 75, 81, 45, 75, 48, 19, 32, 31),
  SAFFL = c("N", "N", "N", "N", "N", "N", "N", "N", "N", "N"),
  PKFL = c("N", "N", "N", "N", "N", "N", "N", "N", "N", "N")
)

ADSL <- ADSL |>
  mutate(TRT01P = as.factor(TRT01P))

create_blank_line <- function(x) {
  list(
    "Mean" = rcell(mean(x), format = "xx.x"),
    " " = rcell(NULL),
    "Max" = rcell(max(x))
  )
}

lyt <- basic_table() |>
  split_cols_by("TRT01P") |>
  analyze("AGE", afun = create_blank_line)

result <- build_table(lyt, ADSL)

result
result <- prune_table(result, prune_func = tern::keep_rows(keep_non_null_rows))

result
}
