% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_poisson.R
\name{Poisson}
\alias{Poisson}
\title{Poisson outcome for kDGLM models}
\usage{
Poisson(lambda, data, offset = as.matrix(data)^0)
}
\arguments{
\item{lambda}{character: The name of the linear predictor associated with the rate (mean) parameter of the Poisson distribution. The parameter is treated as unknown and equal to the exponential of the associated linear predictor.}

\item{data}{numeric: The values of the observed data.}

\item{offset}{numeric: The offset at each observation. Must have the same shape as data.}
}
\value{
A object of the class dlm_distr
}
\description{
Creates an outcome with Poisson distribution with the chosen parameter.
}
\details{
For evaluating the posterior parameters, we use the method proposed in \insertCite{ArtigokParametrico;textual}{kDGLM}.

For the details about the implementation see  \insertCite{ArtigoPacote;textual}{kDGLM}.
}
\examples{

data <- c(AirPassengers)

level <- polynomial_block(rate = 1, D = 0.95, order = 2)
season <- harmonic_block(rate = 1, period = 12, D = 0.975)

outcome <- Poisson(lambda = "rate", data = data)

fitted.data <- fit_model(level, season,
  AirPassengers = outcome
)
summary(fitted.data)

plot(fitted.data, plot.pkg = "base")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fit_model}}

Other auxiliary functions for a creating outcomes: 
\code{\link{Gamma}()},
\code{\link{Multinom}()},
\code{\link{Normal}()},
\code{\link{summary.dlm_distr}()}
}
\concept{auxiliary functions for a creating outcomes}
