% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config_set_backend}
\alias{config_set_backend}
\title{Reload the backend (and the Keras package).}
\usage{
config_set_backend(backend)
}
\arguments{
\item{backend}{String}
}
\value{
Nothing, this function is called for its side effect.
}
\description{
Reload the backend (and the Keras package).
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode python">}}\preformatted{config_set_backend("jax")
}\if{html}{\out{</div>}}
}

\section{WARNING}{
Using this function is dangerous and should be done
carefully. Changing the backend will \strong{NOT} convert
the type of any already-instantiated objects.
Thus, any layers / tensors / etc. already created will no
longer be usable without errors. It is strongly recommended \strong{not}
to keep around \strong{any} Keras-originated objects instances created
before calling \code{config_set_backend()}.

This includes any function or class instance that uses any Keras
functionality. All such code needs to be re-executed after calling
\code{config_set_backend()}.
}

\seealso{
Other config: \cr
\code{\link{config_backend}()} \cr
\code{\link{config_disable_flash_attention}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_dtype_policy}()} \cr
\code{\link{config_enable_flash_attention}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_enable_unsafe_deserialization}()} \cr
\code{\link{config_epsilon}()} \cr
\code{\link{config_floatx}()} \cr
\code{\link{config_image_data_format}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{config_set_dtype_policy}()} \cr
\code{\link{config_set_epsilon}()} \cr
\code{\link{config_set_floatx}()} \cr
\code{\link{config_set_image_data_format}()} \cr
}
\concept{config}
