% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_checkbox.R
\name{question_checkbox}
\alias{question_checkbox}
\title{Checkbox question}
\usage{
question_checkbox(
  text,
  ...,
  correct = "Correct!",
  incorrect = "Incorrect",
  try_again = "Incorrect. Be sure to select every correct answer.",
  allow_retry = FALSE,
  random_answer_order = FALSE
)
}
\arguments{
\item{text}{Question or option text}

\item{...}{Answers created with \code{\link[=answer]{answer()}} or \code{\link[=answer_fn]{answer_fn()}}, or extra
parameters passed onto \code{\link[=question]{question()}}. Function answers do not
appear in the checklist, but are checked first in the order they are
specified.}

\item{correct}{For \code{question}, text to print for a correct answer (defaults
to "Correct!"). For \code{answer}, a boolean indicating whether this answer is
correct.}

\item{incorrect}{Text to print for an incorrect answer (defaults to
"Incorrect") when \code{allow_retry} is \code{FALSE}.}

\item{try_again}{Text to print for an incorrect answer
(defaults to "Incorrect. Be sure to select every correct answer.")
when \code{allow_retry} is \code{TRUE}.}

\item{allow_retry}{Allow retry for incorrect answers. Defaults to \code{FALSE}.}

\item{random_answer_order}{Display answers in a random order.}
}
\value{
Returns a learnr question of type \code{"learnr_checkbox"}.
}
\description{
Creates a checkbox group tutorial quiz question.  The student may select one
or more checkboxes before submitting their answer.
}
\examples{
question_checkbox(
  "Select all the toppings that belong on a Margherita Pizza:",
  answer("tomato", correct = TRUE),
  answer("mozzarella", correct = TRUE),
  answer("basil", correct = TRUE),
  answer("extra virgin olive oil", correct = TRUE),
  answer("pepperoni", message = "Great topping! ... just not on a Margherita Pizza"),
  answer("onions"),
  answer("bacon"),
  answer("spinach"),
  random_answer_order = TRUE,
  allow_retry = TRUE,
  try_again = "Be sure to select all four toppings!"
)

# Set up a question where there's no wrong answer. The answer options are
# always shuffled, but the answer_fn() answer is always evaluated first.
question_checkbox(
  "Which of the tidyverse packages is your favorite?",
  answer("dplyr"),
  answer("tidyr"),
  answer("ggplot2"),
  answer("tibble"),
  answer("purrr"),
  answer("stringr"),
  answer("forcats"),
  answer("readr"),
  answer_fn(function(value) {
    if (length(value) == 1) {
      correct(paste(value, "is my favorite tidyverse package, too!"))
    } else {
      correct("Yeah, I can't pick just one favorite package either.")
    }
  }),
  random_answer_order = TRUE
)

}
\seealso{
Other Interactive Questions: 
\code{\link{question_numeric}()},
\code{\link{question_radio}()},
\code{\link{question_text}()},
\code{\link{quiz}()}
}
\concept{Interactive Questions}
