% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_PresenceAbsence.R
\name{plot.PresenceAbsence}
\alias{plot.PresenceAbsence}
\title{Plot an object of class PresenceAbsence}
\usage{
\method{plot}{PresenceAbsence}(x, name = NULL, world = TRUE, col_rich = NULL, col_name = "red", ...)
}
\arguments{
\item{x}{An object of class \code{\link{PresenceAbsence}}.}

\item{name}{A character specifying a species to be ploted instead of the complete species richness map.}

\item{world}{If \code{TURE} a map of political divisions (countries) is added to the plot.}

\item{col_rich}{Color function (e.g. \code{\link{rainbow}}, \code{\link{heat.colors}}, \code{\link{colorRampPalette}}) to be used in the richness map.}

\item{col_name}{The color to use when ploting single species.}

\item{...}{Other parameters pass to the plot function.}
}
\description{
Plots species richness map from an object of class PresenceAbsence or a
particular species' map.
}
\examples{
\dontrun{
data(PAM)
plot(PAM)
plot(PAM, xlab = "Longitude", ylab = "Latitude",
     main = "Phyllomedusa species richness")
plot(PAM, name = "Phyllomedusa atelopoides")
plot(PAM, name = "Phyllomedusa azurea")
}

}
\seealso{
\code{\link{lets.presab}}

\code{\link{lets.presab.birds}}
}
\author{
Bruno Vilela
}
