% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft.R
\name{ft}
\alias{ft}
\title{Fuzzy transform}
\usage{
ft(x, xmemb, y, order = 1)
}
\arguments{
\item{x}{the numeric matrix of input values}

\item{xmemb}{the partitioning of input values, i.e., a \code{fsets} object with membership degrees
(see \code{\link[=fcut]{fcut()}})}

\item{y}{the numeric vector of target values}

\item{order}{the order of the fuzzy transform (0, 1, 2, ...)}
}
\value{
the instance of the S3 class \code{ft}
}
\description{
Compute a fuzzy tranform of the given input matrix \code{x}.
}
\examples{

# create the fuzzy transform object
y <- (1:30)^2
x <- as.matrix(data.frame(a = 1:30, b = 30:1))
xmemb <- fcut(x,
              breaks = list(a = equidist(x[, 'a'], 3),
                            b = equidist(x[, 'b'], 3)))
fit <- ft(x, xmemb, y, order = 1)

# obtain function values
x2 <- as.matrix(data.frame(a = 10:20, b = 20:10))
xmemb2 <- fcut(x2,
               breaks = list(a = equidist(x[, 'a'], 3),
                             b = equidist(x[, 'b'], 3)))
y2 <- ftinv(fit, x2, xmemb2)
print(y2)

# compare original values with those obtained by the fuzzy transform
y[10:20] - y2

}
\references{
Perfilieva I. Fuzzy transforms: Theory and applications. FUZZY SET SYST,
volume 157, issue 8, p. 993-1023. 2006.
}
\seealso{
\code{\link[=ftinv]{ftinv()}}, \code{\link[=is.ft]{is.ft()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
