% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipalities.R
\docType{data}
\name{Doubice_DC_cz}
\alias{Doubice_DC_cz}
\title{Municipal Election Data: Doubice (DC, CZ)}
\format{
An object of class \code{data.frame} with 151 rows and 14 columns.
}
\source{
\href{https://www.volby.cz/index_en.htm}{Czech Statistical Office},
\href{https://oudoubice.cz/}{Municipality website},
\href{https://www.researchgate.net/publication/323573475_Konfliktni_linie_v_malych_obcich}{Acta Politologica article}
}
\usage{
Doubice_DC_cz
}
\description{
A dataset containing individual-level candidacy records from municipal
elections in the municipality of Doubice (district Decin, Czech republic).
}
\details{
\tabular{ll}{
   \strong{Dataset overview:} \tab  \cr
   Municipality: \tab Doubice \cr
   District: \tab Decin \cr
   Country: \tab Czech Republic \cr
   Number of elections: \tab 11 \cr
   Elections covered: \tab 1993, 1994, 1998, 2002, 2006, 2007, 2010, 2014, 2015, 2018, 2022 \cr
   Number of candidacies (rows): \tab 151 \cr
   Note: \tab \href{https://oudoubice.cz/}{Municipality website} \cr
}
}
\section{Description of variables}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   elections \tab Election identifiers (numeric) \cr
   candidate \tab Candidate's full name (character) \cr
   list_name \tab Name of the candidate list (character) \cr
   list_pos \tab Candidate's position on the list (numeric) \cr
   pref_votes \tab Number of preferential votes (numeric) \cr
   elected \tab Logical; TRUE if candidate was elected \cr
   nom_party \tab Nominating party (character) \cr
   pol_affil \tab Political affiliation (character) \cr
   mayor \tab TRUE if elected mayor \cr
   dep_mayor \tab TRUE if elected deputy mayor \cr
   board \tab TRUE if member of the executive board \cr
   gov_support \tab TRUE if supported the local government \cr
   elig_voters \tab Number of eligible voters (numeric) \cr
   ballots_cast \tab Number of ballots cast (numeric) \cr
}


Each record describes one candidate’s run for office, including their candidate
list affiliation, position on the list, nominating party, political affiliation,
number of preferential votes, and whether they were elected or held specific
positions (mayor, deputy mayor, member of the executive body).

The dataset also includes contextual election-level information, such as the
number of eligible voters and ballots cast, which can be used to calculate
voter turnout and related indicators.
}

\keyword{datasets}
