% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mydiagplot.R
\name{mydiagPlot}
\alias{mydiagPlot}
\title{Make diagnostic plot using the estimated PC subspace}
\usage{
mydiagPlot(x, obj, k, alpha = 0.5, co.sd = 0.25)
}
\arguments{
\item{x}{the input data matrix}

\item{obj}{the returned output from rwltsspca}

\item{k}{dimension of the PC subspace}

\item{alpha}{the robust parameter which takes value between 0 to 0.5, default is 0.5}

\item{co.sd}{cutoff value for score outlier weight, default is 0.25}
}
\value{
the diagnostics of outliers \cr
\item{od}{the orthgonal distances with respect to the k-dimensional PC subspace}
\item{ws.od}{if the observation is outlying in the orthgonal complement of the PC subspace \code{ws.od}=0; otherwise \code{ws.sd}=1}
\item{co.od}{the cutoff value for orthogonal distances}
\item{sc.wt}{the score outlier weight, which is compared with 0.25 (by default) to flag score outliers}
\item{ws.sd}{if the observation is outlying with the PC subspace \code{ws.sd}=0; otherwise \code{ws.sd}=1}
\item{co.sd}{the cutoff value for score outlier weight, default is 0.25}
\item{sc.out}{the retruned object when computing the score outlier weights}
}
\description{
Make diagnostic plot using the estimated PC subspace
}
