% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_twopts.R
\name{cache_counts_twopt}
\alias{cache_counts_twopt}
\title{Frequency of genotypes for two-point recombination fraction estimation}
\usage{
cache_counts_twopt(
  input.seq,
  cached = FALSE,
  cache.prev = NULL,
  ncpus = 1L,
  verbose = TRUE,
  joint.prob = FALSE
)
}
\arguments{
\item{input.seq}{an object of class \code{mappoly.sequence}}

\item{cached}{If \code{TRUE}, access the counts for all
linkage phase configurations in a internal file (default = FALSE)}

\item{cache.prev}{an object of class \code{cache.info} containing
pre-computed genotype frequencies, obtained with
\code{\link[mappoly]{cache_counts_twopt}} (optional, default = NULL)}

\item{ncpus}{Number of parallel processes to spawn (default = 1)}

\item{verbose}{If \code{TRUE} (default), print the linkage phase
configurations. If \code{cached = TRUE}, nothing is
printed, since all linkage phase configurations will be cached.}

\item{joint.prob}{If \code{FALSE} (default), returns the frequency of
genotypes for transition probabilities (conditional
probabilities). If \code{TRUE} returns the frequency for joint
probabilities. The latter is especially important to compute the 
Fisher's Information for a pair of markers.}
}
\value{
An object of class \code{cache.info} which contains one (conditional probabilities)
    or two (both conditional and joint probabilities) lists. Each list
    contains all pairs of dosages between parents for all markers
    in the sequence. The names in each list are of the form 'A-B-C-D', where: A
    represents the dosage in parent 1, marker k; B represents the dosage in parent
    1, marker k+1; C represents the dosage in parent 2, marker k;
    and D represents the dosage in parent 2, marker k+1.  For each
    list, the frequencies were computed for all possible linkage
    phase configurations. The frequencies for each linkage phase
    configuration are distributed in matrices whose names
    represents the number of homologous chromosomes that share
    alleles. The rows on these matrices represents the dosages in markers k
    and k+1 for an individual in the offspring. See Table 3 of
    S3 Appendix in Mollinari and Garcia (2019) for an example.
}
\description{
Returns the frequency of each genotype for two-point reduction
of dimensionality. The frequency is calculated for all pairwise
combinations and for all possible linkage phase configurations.
}
\examples{
    all.mrk <- make_seq_mappoly(tetra.solcap, 1:20)
    ## local computation
    counts <- cache_counts_twopt(all.mrk, ncpus = 1)
    ## load from internal file or web-stored counts (especially important for high ploidy levels)
    counts.cached <- cache_counts_twopt(all.mrk, cached = TRUE)

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu} with updates by Gabriel Gesteira, \email{gdesiqu@ncsu.edu}
}
\keyword{analysis}
\keyword{two-point}
