% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{zero_low_counts}
\alias{zero_low_counts}
\title{Replace low counts with zero}
\usage{
zero_low_counts(
  obj,
  data,
  min_count = 2,
  use_total = FALSE,
  cols = NULL,
  other_cols = FALSE,
  out_names = NULL,
  dataset = NULL
)
}
\arguments{
\item{obj}{A \code{\link{taxmap}} object}

\item{data}{The name of a table in \code{obj$data}.}

\item{min_count}{The minimum number of counts needed for a count to remain
unchanged. Any could less than this will be converted to a zero. For
example, \code{min_count = 2} would remove singletons.}

\item{use_total}{If \code{TRUE}, the \code{min_count} applies to the total
count for each row (e.g. OTU counts for all samples), rather than each cell
in the table. For example \code{use_total = TRUE, min_count = 10} would
convert all counts of any row to zero if the total for all counts in that
row was less than 10.}

\item{cols}{The columns in \code{data} to use. By
default, all numeric columns are used. Takes one of the following inputs:
\describe{
\item{TRUE/FALSE:}{All/No columns will used.}
\item{Character vector:}{The names of columns to use} \item{Numeric vector:}{The indexes of
columns to use}
\item{Vector of TRUE/FALSE of length equal to the number of columns:}{Use the columns corresponding to \code{TRUE} values.} }}

\item{other_cols}{Preserve in the output non-target columns present in the
input data. New columns will always be on the end. The "taxon_id" column
will be preserved in the front. Takes one of the following inputs:
\describe{
\item{NULL:}{No columns will be added back, not even the taxon id column.}
\item{TRUE/FALSE:}{All/None of the non-target columns will be preserved.}
\item{Character vector:}{The names of columns to preserve}
\item{Numeric vector:}{The indexes of columns to preserve}
\item{Vector of TRUE/FALSE of length equal to the number of columns:}{Preserve the columns corresponding to \code{TRUE} values.}}}

\item{out_names}{The names of count columns in the output. Must be the same
length and order as \code{cols} (or \code{unique(groups)}, if \code{groups} is used).}

\item{dataset}{DEPRECIATED. use "data" instead.}
}
\value{
A tibble
}
\description{
For a given table in a \code{\link{taxmap}} object, convert all counts
below a minimum number to zero. This is useful for effectively removing
"singletons", "doubletons", or other low abundance counts.
}
\examples{
# Parse data for examples
x = parse_tax_data(hmp_otus, class_cols = "lineage", class_sep = ";",
                   class_key = c(tax_rank = "taxon_rank", tax_name = "taxon_name"),
                   class_regex = "^(.+)__(.+)$")
                   
# Default use
zero_low_counts(x, "tax_data")

# Use only a subset of columns
zero_low_counts(x, "tax_data", cols = c("700035949", "700097855", "700100489"))
zero_low_counts(x, "tax_data", cols = 4:6)
zero_low_counts(x, "tax_data", cols = startsWith(colnames(x$data$tax_data), "70001"))

# Including all other columns in ouput
zero_low_counts(x, "tax_data", other_cols = TRUE)

# Inlcuding specific columns in output
zero_low_counts(x, "tax_data", cols = c("700035949", "700097855", "700100489"),
                other_cols = 2:3)
               
# Rename output columns
zero_low_counts(x, "tax_data", cols = c("700035949", "700097855", "700100489"),
                out_names = c("a", "b", "c"))
}
\seealso{
Other calculations: 
\code{\link{calc_diff_abund_deseq2}()},
\code{\link{calc_group_mean}()},
\code{\link{calc_group_median}()},
\code{\link{calc_group_rsd}()},
\code{\link{calc_group_stat}()},
\code{\link{calc_n_samples}()},
\code{\link{calc_obs_props}()},
\code{\link{calc_prop_samples}()},
\code{\link{calc_taxon_abund}()},
\code{\link{compare_groups}()},
\code{\link{counts_to_presence}()},
\code{\link{rarefy_obs}()}
}
\concept{calculations}
