% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelNMoE.R
\docType{class}
\name{ModelNMoE-class}
\alias{ModelNMoE-class}
\alias{ModelNMoE}
\title{A Reference Class which represents a fitted NMoE model.}
\description{
ModelNMoE represents an estimated NMoE model.
}
\section{Fields}{

\describe{
\item{\code{param}}{A \link{ParamNMoE} object. It contains the estimated
values of the parameters.}

\item{\code{stat}}{A \link{StatNMoE} object. It contains all the statistics
associated to the NMoE model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("meancurve", "confregions", "clusters", "loglikelihood"), ...)}}{Plot method.
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"meancurve" = } Estimated mean and estimated
        experts means given the input \code{X} (fields \code{Ey} and
        \code{Ey_k} of class \link{StatNMoE}).
      \item \code{"confregions" = } Estimated mean and confidence
        regions. Confidence regions are computed as plus and minus twice
        the estimated standard deviation (the squarre root of the field
        \code{Vary} of class \link{StatNMoE}).
      \item \code{"clusters" = } Estimated experts means (field
        \code{Ey_k}) and hard partition (field \code{klas} of class
        \link{StatNMoE}).
      \item \code{"loglikelihood" = } Value of the log-likelihood for
        each iteration (field \code{stored_loglik} of class
        \link{StatNMoE}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}
By default, all the graphs mentioned above are produced.}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
  \item{\code{digits}}{The number of significant digits to use when
    printing.}
}}
}}

\examples{
data(tempanomalies)
x <- tempanomalies$Year
y <- tempanomalies$AnnualAnomaly

nmoe <- emNMoE(X = x, Y = y, K = 2, p = 1, verbose = TRUE)

# nmoe is a ModelNMoE object. It contains some methods such as 'summary' and 'plot'
nmoe$summary()
nmoe$plot()

# nmoe has also two fields, stat and param which are reference classes as well

# Log-likelihood:
nmoe$stat$loglik

# Parameters of the polynomial regressions:
nmoe$param$beta
}
\seealso{
\link{ParamNMoE}, \link{StatNMoE}
}
