% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiscale_gwr.R
\name{multiscale_gwr}
\alias{multiscale_gwr}
\title{multiscale_gwr
This function adapts the multiscale Geographically Weighted Regression (GWR)
methodology proposed by Fotheringam et al. in 2017, employing a backward
fitting procedure within the MGWRSAR subroutines. The consecutive bandwidth
optimizations are performed by minimizing the corrected Akaike criteria.}
\usage{
multiscale_gwr(formula,data,coords,kernels='bisq',init='GWR',
maxiter=20,nstable=6,tolerance=0.000001,doMC=FALSE,ncore=1,HF=NULL,
H0=NULL,H2=NULL,Model=NULL,model=NULL,get_AICg=FALSE,verbose=FALSE,
control=list(SE=FALSE,adaptive=TRUE,NN=800,isgcv=FALSE,family=gaussian()))
}
\arguments{
\item{formula}{A formula.}

\item{data}{A dataframe.}

\item{coords}{default NULL, a dataframe or a matrix with coordinates.}

\item{kernels}{A vector containing the kernel types. Possible types:
rectangle ("rectangle"), bisquare ("bisq"), tricube ("tcub"), epanechnikov ("epane")}

\item{init}{starting model (lm or GWR)}

\item{maxiter}{maximum number of iterations in the back-fitting procedure.}

\item{nstable}{required number of consecutive unchanged optimal bandwidth (by covariate) before leaving optimisation of bandwidth size, default 3.}

\item{tolerance}{value to terminate the back-fitting iterations (ratio of change in RMSE)}

\item{doMC}{A boolean for Parallel computation, default FALSE.}

\item{ncore}{number of CPU cores for parallel computation, default 1.}

\item{HF}{if available, a vector containing the optimal bandwidth parameters for each
covariate, default NULL.}

\item{H0}{A bandwidth value for the starting GWR model, default NULL.}

\item{H2}{A bandwidth temporal value for the starting GWR model, default NULL.}

\item{Model}{Type of Model.}

\item{model}{A previous model estimated using multiscale_gwr function, default NULL}

\item{get_AICg}{Boolean, should Global AICc be estimated.}

\item{verbose}{Boolean, verbose mode.}

\item{control}{a list of extra control arguments, see MGWRSAR help.}
}
\value{
Return an object of class mgwrsar
}
\description{
multiscale_gwr
This function adapts the multiscale Geographically Weighted Regression (GWR)
methodology proposed by Fotheringam et al. in 2017, employing a backward
fitting procedure within the MGWRSAR subroutines. The consecutive bandwidth
optimizations are performed by minimizing the corrected Akaike criteria.
}
