% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escount.R
\name{escount}
\alias{escount}
\title{Endogenous switching and sample selection models for count data}
\usage{
escount(
  formula,
  data,
  subset,
  weights,
  na.action,
  offset,
  start = NULL,
  R = 16,
  hessian = FALSE,
  method = c("twostep", "ml"),
  model = c("es", "ss")
)
}
\arguments{
\item{formula}{a \code{Formula} object which includes two responses (the
count and the binomial variables) and two sets of covariates
(for the count component and for the selection equation)}

\item{data}{a data frame,}

\item{subset, weights, na.action, offset}{see \code{stats::lm}}

\item{start}{an optional vector of starting values,}

\item{R}{the number of points for the Gauss-Hermite quadrature}

\item{hessian}{if \code{TRUE}, the numerical hessian is computed,
otherwise the covariance matrix of the coefficients is computed
using the outer product of the gradient}

\item{method}{one of \code{'ML'} for maximum likelihood estimation (the
default) or \code{'twostep'} for the two-step NLS method}

\item{model}{one of \code{'es'} for endogenous switching (the default)
or \code{'ss'} for sample selection}
}
\value{
an object of class \verb{c("escount,micsr)"}, see \code{micsr::micsr} for further details.
}
\description{
Heckman's like estimator for count data, using either
maximum likelihood or a two-step estimator
}
\examples{
trips_2s <- escount(trips + car ~ workschl + size + dist + smsa + fulltime + distnod +
realinc + weekend + car | . - car - weekend + adults, data = trips, method = "twostep")
trips_ml <- update(trips_2s, method = "ml")
}
\references{
\insertRef{TERZ:98}{micsr}

\insertRef{GREE:01}{micsr}
}
\author{
Yves Croissant
}
\keyword{models}
