% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{calc_perf_bootstrap_split}
\alias{calc_perf_bootstrap_split}
\title{Calculate performance for a single split from \code{\link[rsample:bootstraps]{rsample::bootstraps()}}}
\usage{
calc_perf_bootstrap_split(
  test_data_split,
  trained_model,
  outcome_colname,
  perf_metric_function,
  perf_metric_name,
  class_probs,
  method,
  seed
)
}
\arguments{
\item{test_data_split}{a single bootstrap of the test set from \code{\link[rsample:bootstraps]{rsample::bootstraps()}}}

\item{trained_model}{Trained model from \code{\link[caret:train]{caret::train()}}.}

\item{outcome_colname}{Column name as a string of the outcome variable
(default \code{NULL}; the first column will be chosen automatically).}

\item{perf_metric_function}{Function to calculate the performance metric to
be used for cross-validation and test performance. Some functions are
provided by caret (see \code{\link[caret:postResample]{caret::defaultSummary()}}).
Defaults: binary classification = \code{twoClassSummary},
multi-class classification = \code{multiClassSummary},
regression = \code{defaultSummary}.}

\item{perf_metric_name}{The column name from the output of the function
provided to perf_metric_function that is to be used as the performance metric.
Defaults: binary classification = \code{"ROC"},
multi-class classification = \code{"logLoss"},
regression = \code{"RMSE"}.}

\item{class_probs}{Whether to use class probabilities (TRUE for categorical outcomes, FALSE for numeric outcomes).}

\item{method}{ML method.
Options: \code{c("glmnet", "rf", "rpart2", "svmRadial", "xgbTree")}.
\itemize{
\item glmnet: linear, logistic, or multiclass regression
\item rf: random forest
\item rpart2: decision tree
\item svmRadial: support vector machine
\item xgbTree: xgboost
}}

\item{seed}{Random seed (default: \code{NA}).
Your results will only be reproducible if you set a seed.}
}
\value{
a long data frame of performance metrics for \code{\link[rsample:int_pctl]{rsample::int_pctl()}}
}
\description{
Used by \code{\link[=bootstrap_performance]{bootstrap_performance()}}.
}
\author{
Kelly Sovacool, \email{sovacool@umich.edu}
}
\keyword{internal}
