% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_list.R
\name{export_list}
\alias{export_list}
\title{Export List with Advanced Directory Management}
\usage{
export_list(split_dt, export_path = tempdir(), file_type = "txt")
}
\arguments{
\item{split_dt}{A \code{list} of \code{data.frame}, \code{data.table}, or compatible data structures
to be exported.}

\item{export_path}{Base directory path for file export. Defaults to a temporary directory
created by \code{tempdir()}.}

\item{file_type}{File export format, either \code{"txt"} (tab-separated) or \code{"csv"}.
Defaults to \code{"txt"}.}
}
\value{
An \code{integer} representing the total number of files exported successfully.
}
\description{
The \code{export_list} function exports a list of \code{data.frame}, \code{data.table}, or compatible data structures
with sophisticated directory handling, flexible naming, and multiple file format support.
}
\details{
Comprehensive List Export Features:
\itemize{
\item Advanced nested directory structure support based on list element names
\item Intelligent handling of unnamed list elements
\item Automatic conversion to \code{data.table} for consistent export
\item Hierarchical directory creation with nested path names
\item Multi-format file export with intelligent separator selection
\item Robust error handling and input validation
}

File Export Capabilities:
\itemize{
\item Supports \code{"txt"} (tab-separated) and \code{"csv"} formats
\item Intelligent file naming based on list element names
\item Handles complex nested directory structures
\item Efficient file writing using \code{data.table::fwrite()}
}
}
\note{
Key Capabilities:
\itemize{
\item Flexible list naming and directory management
\item Comprehensive support for \code{data.frame} and \code{data.table} inputs
\item Intelligent default naming for unnamed elements
\item High-performance file writing mechanism
}
}
\examples{
# Example: Export split data to files

# Step 1: Create split data structure
dt_split <- w2l_split(
  data = iris,              # Input iris dataset
  cols2l = 1:2,             # Columns to be split
  by = "Species"            # Grouping variable
)

# Step 2: Export split data to files
export_list(
  split_dt = dt_split       # Input list of data.tables
)
# Returns the number of files created
# Files are saved in tempdir() with .txt extension

# Check exported files
list.files(
  path = tempdir(),         # Default export directory
  pattern = "txt",          # File type pattern to search
  recursive = TRUE          # Search in subdirectories
)

# Clean up exported files
files <- list.files(
  path = tempdir(),         # Default export directory
  pattern = "txt",          # File type pattern to search
  recursive = TRUE,         # Search in subdirectories
  full.names = TRUE         # Return full file paths
)
file.remove(files)          # Remove all exported files
}
