% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{TPB_2SO}
\alias{TPB_2SO}
\title{TPB_2SO}
\description{
A simulated dataset based on the Theory of Planned Behaviour,
where INT is a higher order construct of ATT and SN, and PBC is a higher order
construct of PC and PB.
}
\examples{
tpb <- '
  # First order constructs
  ATT =~ att1 + att2 + att3
  SN  =~ sn1 + sn2 + sn3
  PB =~ pb1 + pb2 + pb3
  PC =~ pc1 + pc2 + pc3
  BEH =~ b1 + b2

  # Higher order constructs
  INT =~ ATT + SN
  PBC =~ PC + PB

  # Higher order interaction
  INTxPBC =~ ATT:PC + ATT:PB + SN:PC + SN:PB

  # Structural model
  BEH ~ PBC + INT + INTxPBC
'

\dontrun{
est <- modsem(tpb, data = TPB_2SO, method = "ca")
summary(est)
}
}
