% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.traitMedusa.model.R
\name{plot.traitMedusa.model}
\alias{plot.traitMedusa.model}
\title{Tree plotting for rates}
\usage{
\method{plot}{traitMedusa.model}(x, y = NULL, ..., reconType = "rates", palette = "hotspot.colors")
}
\arguments{
\item{x}{Output from \code{\link{summary.traitMedusa}}.}

\item{y}{A matrix of trait values.}

\item{...}{Other functions to pass to \code{\link[ape]{plot.phylo}}}

\item{reconType}{Colour branches according to rate shifts ("rates" - requires traitMedusaObject) or ancestral state reconstruction ("picReconstruction"  - requires x).}

\item{palette}{Defines the colour scheme with four options: hotspot.colors (red to blue), heat.colors (yellow to red), cool.colors (blues), combi.colors (yellows to reds and blues)}
}
\value{
Returns a data frame of colours used in plot along with rate (or ancestral state) range for each colour.
}
\description{
Plots trees with colours based on rates of trait evolution. Also provides simple coloured plotting for trait values using the \code{\link[ape]{ace}} function in the \pkg{ape} library.
}
\examples{
# Data and phylogeny
data(anolis.tree)
data(anolis.data)

# female SVL data
female.svl <- matrix(anolis.data[,"Female_SVL"], 
dimnames=list(rownames(anolis.data)))
input.data <- sortTraitData(phy=anolis.tree, y=female.svl, log.trait=TRUE)

# arbitarily reduce data size for speed in this example
phy.clade <- extract.clade(input.data[[1]], 182)
male.length.clade <- as.matrix(input.data[[2]][match(input.data[[1]]$tip.label, 
rownames(input.data[[2]])),])
# Identify rate shifts and print and plot results with up to one rate shifts 
# and minimum clade size of 10.
anolisSVL_MEDUSA <- transformPhylo.ML(male.length.clade, phy=phy.clade, 
model="tm1",minCladeSize=10, nSplits=1)
anolisSVL_MEDUSA_out <- summary(anolisSVL_MEDUSA, cutoff=1, AICc=FALSE)
colours <- plot(x = anolisSVL_MEDUSA_out,
reconType = "rates", type = "fan", cex=0.6, edge.width=3)
}
\seealso{
\code{\link{transformPhylo.ML}}, \code{\link{summary.traitMedusa}}.
}
\author{
Gavin Thomas, Mark Puttick
}
