% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtar.R
\docType{data}
\name{iceland.rf}
\alias{iceland.rf}
\title{Temperature, rainfall and two rivers' flows in Iceland.}
\format{
A data frame with 1096 rows and 5 variables:
\describe{
  \item{Vatnsdalsa}{a numerical vector indicating the Vatnsdalsá river flow.}
  \item{Jokulsa}{a numerical vector indicating the Jökulsá Eystri river flow.}
  \item{Precipitation}{a numerical vector indicating the rainfall.}
  \item{Temperature}{a numerical vector indicating the temperature.}
  \item{Date}{a vector that indicates the date each measurement was performed.}
}
}
\usage{
data(iceland.rf)
}
\description{
These data correspond to two daily series of river flows, in cubic meters
per second, in Iceland, from January 1, 1972, to December 12, 1974. In addition, daily
series of precipitation, measured in millimeters, and temperature, measured in degrees
Celsius, were collected at the Hveravellir meteorological station. The recorded
precipitation value corresponds to the accumulated precipitation up to 9:00 A.M.
since the same time the previous day.
}
\examples{
data(iceland.rf)
dev.new()
plot(ts(as.matrix(iceland.rf[,-5])), main="Iceland")

}
\references{
Tong, Howell (1990) Non‑linear Time Series: A Dynamical System Approach.
            Oxford University Press. Oxford, UK.

Ruey S., Tsay (1998) Testing and Modeling Multivariate Threshold Models.
            Journal of the American Statistical Association, 93, 1188-1202.
}
\keyword{datasets}
