% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsc_inference.R
\name{bootstrap_plsc}
\alias{bootstrap_plsc}
\title{Bootstrap inference for PLSC loadings}
\usage{
bootstrap_plsc(
  x,
  X,
  Y,
  nboot = 500,
  comps = ncomp(x),
  seed = NULL,
  parallel = FALSE,
  epsilon = 1e-09,
  ...
)
}
\arguments{
\item{x}{A fitted \code{plsc} object.}

\item{X}{Original X block.}

\item{Y}{Original Y block.}

\item{nboot}{Number of bootstrap samples (default 500).}

\item{comps}{Number of components to bootstrap (default: \code{ncomp(x)}).}

\item{seed}{Optional integer seed for reproducibility.}

\item{parallel}{Use future.apply for parallelization (default FALSE).}

\item{epsilon}{Small positive constant to stabilize division for ratios.}

\item{...}{Additional arguments (currently unused).}
}
\description{
Provides bootstrap ratios (mean / sd) for X and Y loadings to assess stability,
mirroring common practice in Behavior PLSC.
}
