% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{pca_outliers}
\alias{pca_outliers}
\title{PCA Outlier Diagnostics}
\usage{
pca_outliers(x, X, ncomp, cutoff = FALSE)
}
\arguments{
\item{x}{A \code{pca} object.}

\item{X}{The original data matrix used for PCA.}

\item{ncomp}{Number of components to consider.}

\item{cutoff}{Logical or numeric specifying threshold for labeling outliers. If \code{TRUE},
uses some typical statistical threshold (F-dist) for T^2, or sets an arbitrary Q limit.
If numeric, treat it as a cutoff. Default is \code{FALSE} (no labeling).}
}
\value{
A data frame with columns \code{T2} and \code{Q}, and optionally an outlier flag.
}
\description{
Calculates Hotelling T^2 (score distance) and Q-residual (orthogonal distance)
for each observation, given a chosen number of components.
}
