% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_sc.R
\name{ScPhyloExpressionSet_from_seurat}
\alias{ScPhyloExpressionSet_from_seurat}
\title{Convert Seurat Object to Single-Cell PhyloExpressionSet}
\usage{
ScPhyloExpressionSet_from_seurat(
  seurat,
  strata,
  layer = "counts",
  selected_idents = NULL,
  name = "Single-Cell PhyloExpressionSet",
  seed = 42,
  ...
)
}
\arguments{
\item{seurat}{A Seurat object containing single-cell expression data}

\item{strata}{Factor vector of phylostratum assignments for each gene}

\item{layer}{Character string specifying which layer to use from the Seurat object (default: "counts")}

\item{selected_idents}{Character string specifying which metadata column to use for grouping (default: NULL, uses active idents)}

\item{name}{A character string naming the dataset (default: "Single-Cell Phylo Expression Set")}

\item{seed}{Integer seed for reproducible UMAP computation (default: 42)}

\item{...}{Additional arguments passed to ScPhyloExpressionSet constructor}
}
\value{
A ScPhyloExpressionSet object
}
\description{
Convert a Seurat object with phylostratum information into a 
ScPhyloExpressionSet object for single-cell phylotranscriptomic analysis.
Automatically extracts dimensional reductions if present, or computes basic
PCA and UMAP if none are available.
}
