% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_bulk.R
\name{TXI_conf_int}
\alias{TXI_conf_int}
\title{Confidence Intervals for Transcriptomic Index (TXI)}
\usage{
TXI_conf_int(phyex_set, probs = c(0.025, 0.975))
}
\arguments{
\item{phyex_set}{A BulkPhyloExpressionSet object}

\item{probs}{Numeric vector of probabilities for the confidence interval (default: c(0.025, 0.975))}
}
\value{
A tibble with first column Identity names, second column lower bound, third column upper bound
}
\description{
Compute confidence intervals for the TXI using bootstrapped TXI values.
}
\details{
This function returns confidence intervals for the TXI for each identity (sample or group),
based on the bootstrapped TXI values stored in the PhyloExpressionSet object.
}
