% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_stats.R
\name{modal_control}
\alias{modal_control}
\title{Modal Control}
\usage{
modal_control(A, B)
}
\arguments{
\item{A}{A \eqn{n x n} matrix.}

\item{B}{A \eqn{n x m} matrix.}
}
\value{
A \eqn{m x n} matrix representing the control of the \eqn{n}th mode by the mth control input.
}
\description{
Calculates the modal control \insertCite{hamdanMeasuresModalControllability1989}{netcontrol} of a system defined by \eqn{x_(t+1) = Ax_(t) + Bu_(t)}.
}
\examples{
A = matrix(c(0,-3,-2,2,-2,1,-1,2,-1), 3,3)
B = diag(3)

modal_control(A, B)
}
